package software.rsquared.restapi;

import android.util.Log;

import software.rsquared.androidlogger.Tag;


/**
 * @author Rafał Zajfert
 */
class DefaultLogger implements RestApiLogger {

	@Override
	public void verbose(String tag, String msg) {
		try {
			software.rsquared.androidlogger.Logger.verbose(new Tag(tag), msg);
		} catch (Exception e) {
			Log.v(tag, msg);
		}
	}

	@Override
	public void debug(String tag, String msg) {
		try {
			software.rsquared.androidlogger.Logger.debug(new Tag(tag), msg);
		} catch (Exception e) {
			Log.d(tag, msg);
		}
	}

	@Override
	public void info(String tag, String msg) {
		try {
			software.rsquared.androidlogger.Logger.info(new Tag(tag), msg);
		} catch (Exception e) {
			Log.i(tag, msg);
		}
	}
}
