/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi.exceptions;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DefaultErrorResponse {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="code")
    private int errorCode;
    @JsonProperty(value="errors")
    private Map<String, String[]> errors = new HashMap<String, String[]>();

    @JsonSetter(value="errors")
    public void setErrors(Map<String, List<Object>> errors) {
        if (errors == null) {
            return;
        }
        this.errors.putAll(this.parseErrorsMap(null, errors));
    }

    private Map<String, String[]> parseErrorsMap(String objectName, Map<String, List<Object>> errors) {
        HashMap<String, String[]> resultMap = new HashMap<String, String[]>();
        for (Map.Entry<String, List<Object>> entry : errors.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            if (entry.getValue().get(0) instanceof String) {
                String[] values = new String[entry.getValue().size()];
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    values[i] = String.valueOf(entry.getValue().get(0));
                }
                String key = entry.getKey();
                if (objectName != null) {
                    key = objectName + "[" + key + "]";
                }
                resultMap.put(key, values);
                continue;
            }
            if (!(entry.getValue().get(0) instanceof Map)) continue;
            String key = entry.getKey();
            if (objectName != null) {
                key = objectName + "[" + key + "]";
            }
            for (Object map : entry.getValue()) {
                resultMap.putAll(this.parseErrorsMap(key, (Map)map));
            }
        }
        return resultMap;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Map<String, String[]> getErrors() {
        return this.errors;
    }
}

