/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.restapi.PoolRequest;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RestApi;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.RequestPoolListener;

class ThreadPoolRequest
extends PoolRequest<ThreadPoolRequest> {
    private Map<Integer, Object> results = new LinkedHashMap<Integer, Object>();
    private RequestPoolListener listener;

    public ThreadPoolRequest(int poolSize) {
        super(poolSize);
    }

    @Override
    public void execute(RequestPoolListener listener) {
        if (this.executed) {
            throw new IllegalStateException("Already executed.");
        }
        this.executed = true;
        this.listener = listener;
        if (this.listener != null) {
            this.listener.onPreExecute();
        }
        for (Map.Entry entry : this.requestPool.entrySet()) {
            this.executor.submit(((Request)entry.getValue()).createRequestTask(), ((Request)entry.getValue()).isErrorCallbackIgnored() ? null : RestApi.getConfiguration().getErrorCallback(), new PoolRequest.PoolRequestListener((int)((Integer)entry.getKey())){

                public void onSuccess(Object result) {
                    int requestCode = this.getRequestCode();
                    ThreadPoolRequest.this.results.put(requestCode, result);
                    if (ThreadPoolRequest.this.listener != null) {
                        ThreadPoolRequest.this.listener.onTaskSuccess(result, requestCode);
                    }
                    this.checkFinished();
                }

                @Override
                public void onFailed(RequestException e) {
                    int requestCode = this.getRequestCode();
                    if (ThreadPoolRequest.this.listener != null && ThreadPoolRequest.this.listener.onFailed(e, requestCode)) {
                        ThreadPoolRequest.this.stopExecute();
                    } else {
                        ThreadPoolRequest.this.results.put(requestCode, null);
                    }
                    this.checkFinished();
                }

                @Override
                public void onCancel() {
                    ThreadPoolRequest.this.cancelled = true;
                }

                private void checkFinished() {
                    if (ThreadPoolRequest.this.results.size() == ThreadPoolRequest.this.requestPool.size() || ThreadPoolRequest.this.cancelled) {
                        ThreadPoolRequest.this.stopExecute();
                        if (ThreadPoolRequest.this.listener != null) {
                            if (ThreadPoolRequest.this.cancelled) {
                                ThreadPoolRequest.this.listener.onCancel();
                            } else {
                                ThreadPoolRequest.this.listener.onSuccess(ThreadPoolRequest.this.results);
                            }
                            ThreadPoolRequest.this.listener.onPostExecute();
                        }
                    }
                }
            });
        }
        this.executor.shutdown();
    }
}

