/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.logcat.LogcatLogger;
import software.rsquared.androidlogger.logcat.LogcatLoggerConfig;
import software.rsquared.restapi.BasicAuthorization;
import software.rsquared.restapi.InitialRequirements;
import software.rsquared.restapi.PoolRequest;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RestAuthorizationService;
import software.rsquared.restapi.SerialPoolRequest;
import software.rsquared.restapi.ThreadPoolRequest;
import software.rsquared.restapi.exceptions.DefaultErrorResponse;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.ErrorCallback;
import software.rsquared.restapi.listeners.RequestListener;
import software.rsquared.restapi.listeners.RequestPoolListener;
import software.rsquared.restapi.serialization.Deserializer;
import software.rsquared.restapi.serialization.ErrorDeserializer;
import software.rsquared.restapi.serialization.JsonDeserializer;
import software.rsquared.restapi.serialization.JsonErrorDeserializer;
import software.rsquared.restapi.serialization.JsonSerializer;
import software.rsquared.restapi.serialization.Serializer;

public class RestApi {
    public static final int THREAD_POOL_EXECUTOR = 1;
    public static final int SERIAL_EXECUTOR = 2;
    private static Config sConfiguration;

    static Config getConfiguration() {
        return sConfiguration;
    }

    public static void setConfiguration(Config configuration) {
        sConfiguration = configuration;
    }

    static Logger getLogger() {
        return sConfiguration.logger;
    }

    static boolean isConfigured() {
        return sConfiguration != null;
    }

    public static <E> void execute(Request<E> request, RequestListener<E> listener) {
        request.execute(listener);
    }

    public static <E> E executeSync(Request<E> request) throws RequestException {
        return request.execute().get();
    }

    public static PoolBuilder pool(int executor) {
        return new PoolBuilder(executor);
    }

    public static class Config {
        public static final String HTTP = "http";
        public static final String HTTPS = "https";
        private int timeout = 60000;
        private String scheme = "http";
        private String host;
        private int port = -1;
        @Nullable
        private BasicAuthorization basicAuthorization;
        @Nullable
        private InitialRequirements initialRequirements;
        private Logger logger = new LogcatLogger();
        @NonNull
        private ErrorDeserializer errorDeserializer = new JsonErrorDeserializer();
        @NonNull
        private Deserializer deserializer = new JsonDeserializer();
        @NonNull
        private Serializer serializer = new JsonSerializer();
        private RestAuthorizationService userService;
        private Class<? extends DefaultErrorResponse> errorResponseClass;
        private RestAuthorizationService restAuthorizationService;
        private Map<String, String> headers = new HashMap<String, String>();
        private ErrorCallback errorCallback;

        public int getTimeout() {
            return this.timeout;
        }

        public Config setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public String getScheme() {
            return this.scheme;
        }

        public Config setScheme(@NonNull String scheme) {
            this.scheme = scheme;
            return this;
        }

        public String getHost() {
            return this.host;
        }

        public Config setHost(@NonNull String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Config setPort(int port) {
            this.port = port;
            return this;
        }

        @Nullable
        public BasicAuthorization getBasicAuthorization() {
            return this.basicAuthorization;
        }

        public Config setAuthorization(@NonNull String user, @NonNull String password) {
            if (TextUtils.isEmpty((CharSequence)user) || TextUtils.isEmpty((CharSequence)password)) {
                this.basicAuthorization = null;
                return this;
            }
            this.basicAuthorization = new BasicAuthorization(user, password);
            return this;
        }

        @Nullable
        public InitialRequirements getInitialRequirements() {
            return this.initialRequirements;
        }

        public Config setInitialRequirements(@NonNull InitialRequirements initialRequirements) {
            this.initialRequirements = initialRequirements;
            return this;
        }

        @NonNull
        public Deserializer getDeserializer() {
            return this.deserializer;
        }

        public Config setDeserializer(@NonNull Deserializer deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        @NonNull
        public Serializer getSerializer() {
            return this.serializer;
        }

        public Config setSerializer(@NonNull Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        @Nullable
        public RestAuthorizationService getRestAuthorizationService() {
            return this.restAuthorizationService;
        }

        public Config setRestAuthorizationService(RestAuthorizationService authorizationService) {
            this.restAuthorizationService = authorizationService;
            return this;
        }

        @NonNull
        public ErrorDeserializer getErrorDeserializer() {
            return this.errorDeserializer;
        }

        public Config setErrorDeserializer(@NonNull ErrorDeserializer errorDeserializer) {
            this.errorDeserializer = errorDeserializer;
            return this;
        }

        public Config setLogLevel(Level level) {
            ((LogcatLogger)this.logger).setConfig((LogcatLoggerConfig)new LogcatLoggerConfig().setLevel(level));
            return this;
        }

        public Config addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Config removeHeader(String name) {
            this.headers.remove(name);
            return this;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public ErrorCallback getErrorCallback() {
            return this.errorCallback;
        }

        public Config setErrorCallback(ErrorCallback errorCallback) {
            this.errorCallback = errorCallback;
            return this;
        }
    }

    public static class PoolBuilder {
        protected Map<Integer, Request> mRequestPool = new LinkedHashMap<Integer, Request>();
        private int mExecutor;

        public PoolBuilder(int executor) {
            this.mExecutor = executor;
        }

        public PoolRequest build() {
            PoolRequest poolRequest;
            switch (this.mExecutor) {
                case 1: {
                    poolRequest = new ThreadPoolRequest(this.mRequestPool.size());
                    break;
                }
                default: {
                    poolRequest = new SerialPoolRequest();
                }
            }
            for (Map.Entry<Integer, Request> entry : this.mRequestPool.entrySet()) {
                poolRequest.addTask(entry.getValue(), entry.getKey());
            }
            return poolRequest;
        }

        public void execute(RequestPoolListener listener) {
            PoolRequest poolRequest = this.build();
            poolRequest.execute(listener);
        }

        public PoolBuilder add(@NonNull Request request, int requestCode) {
            this.mRequestPool.put(requestCode, request);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Executor {
    }
}

