/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionSpec;
import okhttp3.MediaType;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.logcat.LogcatLogger;
import software.rsquared.androidlogger.logcat.LogcatLoggerConfig;
import software.rsquared.restapi.BasicAuthorization;
import software.rsquared.restapi.InitialRequirements;
import software.rsquared.restapi.MockFactory;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RestAuthorizationService;
import software.rsquared.restapi.listeners.ErrorCallback;
import software.rsquared.restapi.serialization.Deserializer;
import software.rsquared.restapi.serialization.ErrorDeserializer;
import software.rsquared.restapi.serialization.JsonDeserializer;
import software.rsquared.restapi.serialization.JsonErrorDeserializer;
import software.rsquared.restapi.serialization.ObjectToFormSerializer;
import software.rsquared.restapi.serialization.Serializer;

public class RestApiConfiguration {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    private Set<Integer> successStatusCodes = new HashSet<Integer>(Collections.singletonList(200));
    private int timeout = 60000;
    private String scheme = "http";
    private String host;
    private int port = -1;
    private MediaType mediaType = Request.APPLICATION_URLENCODED;
    @Nullable
    private BasicAuthorization basicAuthorization;
    @Nullable
    private InitialRequirements initialRequirements;
    private Logger logger = new LogcatLogger();
    @NonNull
    private ErrorDeserializer errorDeserializer = new JsonErrorDeserializer();
    @NonNull
    private Deserializer deserializer = new JsonDeserializer();
    @NonNull
    private Serializer serializer = new ObjectToFormSerializer();
    private MockFactory mockFactory;
    private RestAuthorizationService restAuthorizationService;
    private Map<String, String> headers = new HashMap<String, String>();
    private ErrorCallback errorCallback;
    private ConnectionSpec connectionSpec;
    private CertificatePinner certificatePinner;
    private boolean enableTls12OnPreLollipop = false;

    public int getTimeout() {
        return this.timeout;
    }

    public RestApiConfiguration setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public RestApiConfiguration setScheme(@NonNull String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public RestApiConfiguration setHost(@NonNull String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RestApiConfiguration setPort(int port) {
        this.port = port;
        return this;
    }

    @Nullable
    public BasicAuthorization getBasicAuthorization() {
        return this.basicAuthorization;
    }

    public RestApiConfiguration setAuthorization(@NonNull String user, @NonNull String password) {
        if (TextUtils.isEmpty((CharSequence)user) || TextUtils.isEmpty((CharSequence)password)) {
            this.basicAuthorization = null;
            return this;
        }
        this.basicAuthorization = new BasicAuthorization(user, password);
        return this;
    }

    @Nullable
    public InitialRequirements getInitialRequirements() {
        return this.initialRequirements;
    }

    public RestApiConfiguration setInitialRequirements(@NonNull InitialRequirements initialRequirements) {
        this.initialRequirements = initialRequirements;
        return this;
    }

    @NonNull
    public Deserializer getDeserializer() {
        return this.deserializer;
    }

    public RestApiConfiguration setDeserializer(@NonNull Deserializer deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    @NonNull
    public Serializer getSerializer() {
        return this.serializer;
    }

    public RestApiConfiguration setSerializer(@NonNull Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    @Nullable
    public RestAuthorizationService getRestAuthorizationService() {
        return this.restAuthorizationService;
    }

    public RestApiConfiguration setRestAuthorizationService(RestAuthorizationService authorizationService) {
        this.restAuthorizationService = authorizationService;
        return this;
    }

    @NonNull
    public ErrorDeserializer getErrorDeserializer() {
        return this.errorDeserializer;
    }

    public RestApiConfiguration setErrorDeserializer(@NonNull ErrorDeserializer errorDeserializer) {
        this.errorDeserializer = errorDeserializer;
        return this;
    }

    public RestApiConfiguration setLogLevel(@NonNull Level level) {
        ((LogcatLogger)this.logger).setConfig((LogcatLoggerConfig)new LogcatLoggerConfig().setLevel(level));
        return this;
    }

    public RestApiConfiguration addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public RestApiConfiguration removeHeader(String name) {
        this.headers.remove(name);
        return this;
    }

    @NonNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Nullable
    public ErrorCallback getErrorCallback() {
        return this.errorCallback;
    }

    public RestApiConfiguration setErrorCallback(@Nullable ErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
        return this;
    }

    public Set<Integer> getSuccessStatusCodes() {
        return this.successStatusCodes;
    }

    public RestApiConfiguration setSuccessStatusCodes(Set<Integer> successStatusCodes) {
        this.successStatusCodes = successStatusCodes;
        return this;
    }

    public RestApiConfiguration setSuccessStatusCodes(int ... successStatusCodes) {
        this.successStatusCodes = new HashSet<Integer>();
        for (int code : successStatusCodes) {
            this.successStatusCodes.add(code);
        }
        return this;
    }

    public ConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    public RestApiConfiguration setConnectionSpec(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
        return this;
    }

    public CertificatePinner getCertificatePinner() {
        return this.certificatePinner;
    }

    public RestApiConfiguration setCertificatePinner(CertificatePinner certificatePinner) {
        this.certificatePinner = certificatePinner;
        return this;
    }

    public boolean isEnableTls12OnPreLollipop() {
        return this.enableTls12OnPreLollipop;
    }

    public RestApiConfiguration setEnableTls12OnPreLollipop(boolean enableTls12OnPreLollipop) {
        this.enableTls12OnPreLollipop = enableTls12OnPreLollipop;
        return this;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public RestApiConfiguration setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public RestApiConfiguration setMockFactory(MockFactory mockFactory) {
        this.mockFactory = mockFactory;
        return this;
    }

    public MockFactory getMockFactory() {
        return this.mockFactory;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

