/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi.exceptions;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import software.rsquared.restapi.exceptions.AccessTokenException;

public class RequestException
extends ExecutionException {
    public static final int CODE_OK = 200;
    public static final int CODE_ACCEPTED = 202;
    public static final int CODE_BAD_REQUEST = 400;
    public static final int CODE_UNAUTHORIZED = 401;
    public static final int CODE_FORBIDDEN = 403;
    public static final int CODE_NOT_FOUND = 404;
    public static final int CODE_METHOD_NOT_ALLOWED = 405;
    public static final int CODE_TIMEOUT = 408;
    public static final int CODE_TOO_MANY_REQUESTS = 429;
    public static final int CODE_INTERNAL_SERVER_ERROR = 500;
    public static final int CODE_SERVICE_UNAVAILABLE = 503;
    public static final int UNKNOWN = -1;
    public static final int INTERRUPTED = -2;
    public static final int TIMEOUT = -3;
    public static final int INVALID_ACCESS_TOKEN = -3;
    private final int responseCode;
    private final String name;
    private final String message;
    private final int errorCode;
    private final Map<String, String[]> errorsMap;

    public RequestException(@NonNull Exception e) {
        super(e);
        this.name = "Internal error";
        this.message = e.getMessage();
        this.responseCode = e instanceof InterruptedException ? -2 : (e instanceof TimeoutException ? -3 : (e instanceof AccessTokenException ? -3 : -1));
        this.errorCode = -1;
        this.errorsMap = new HashMap<String, String[]>();
    }

    public RequestException(int responseCode, String name, String message, int errorCode, Map<String, String[]> errorsMap) {
        this.responseCode = responseCode;
        this.name = name;
        this.message = message;
        this.errorCode = errorCode;
        this.errorsMap = errorsMap;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Map<String, String[]> getErrorsMap() {
        return this.errorsMap;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append(" ").append(this.errorCode).append("[").append(this.responseCode).append("] ");
        if (!TextUtils.isEmpty((CharSequence)this.name)) {
            builder.append(this.name);
        }
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            builder.append("\n");
            builder.append(this.message);
        }
        for (Map.Entry<String, String[]> entry : this.errorsMap.entrySet()) {
            builder.append("\n");
            builder.append(entry.getKey()).append(": ").append(Arrays.toString(entry.getValue()));
        }
        return builder.toString() + "\n" + super.toString();
    }
}

