/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.TlsVersion;
import software.rsquared.androidlogger.Logger;
import software.rsquared.restapi.Authorizable;
import software.rsquared.restapi.BasicAuthorization;
import software.rsquared.restapi.InitialRequirements;
import software.rsquared.restapi.MockFactory;
import software.rsquared.restapi.Parameter;
import software.rsquared.restapi.RequestExecutor;
import software.rsquared.restapi.RequestFuture;
import software.rsquared.restapi.RestApi;
import software.rsquared.restapi.RestApiConfiguration;
import software.rsquared.restapi.RestAuthorizationService;
import software.rsquared.restapi.ThreadLock;
import software.rsquared.restapi.Timer;
import software.rsquared.restapi.Tls12SocketFactory;
import software.rsquared.restapi.exceptions.InitialRequirementsException;
import software.rsquared.restapi.exceptions.RefreshTokenException;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.exceptions.UserServiceNotInitialized;
import software.rsquared.restapi.listeners.RequestListener;
import software.rsquared.restapi.serialization.Deserializer;
import software.rsquared.restapi.serialization.ErrorDeserializer;
import software.rsquared.restapi.serialization.JsonSerializer;
import software.rsquared.restapi.serialization.Serializer;

public abstract class Request<T> {
    public static final MediaType MULTIPART_FORM_DATA = MediaType.parse((String)"multipart/form-data");
    public static final MediaType APPLICATION_URLENCODED = MediaType.parse((String)"application/x-www-form-urlencoded");
    public static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    protected static final String ACCESS_TOKEN = "access_token";
    protected static final String AUTHORIZATION = "BasicAuthorization";
    protected static final String CONTENT_TYPE = "Content-Type";
    private static final ThreadLock LOCK = new ThreadLock();
    protected OkHttpClient httpClient;
    private RequestExecutor executor;
    private final List<Parameter> bodyParameters = new ArrayList<Parameter>();
    private final List<Parameter> urlParameters = new ArrayList<Parameter>();
    private final Map<String, String> headerMap = new HashMap<String, String>();
    private final Timer timer = new Timer();
    private MediaType mediaType = APPLICATION_URLENCODED;
    private String[] urlSegments;
    private String url;
    private long minExecutionTime;
    private boolean authorizedRequest;
    private RestAuthorizationService userService;
    private MockFactory mockFactory;
    private boolean ignoreErrorCallback;
    private boolean disableLogging;

    protected Request() {
        if (!this.isConfigured()) {
            throw new IllegalStateException("RestApi must be configured before using requests");
        }
        RestApiConfiguration configuration = this.getConfiguration();
        this.iniRequest(configuration);
    }

    protected void iniRequest(RestApiConfiguration configuration) {
        this.httpClient = this.createHttpClient(configuration).build();
        this.executor = new RequestExecutor(1, configuration.getTimeout());
        this.userService = configuration.getRestAuthorizationService();
        this.mockFactory = configuration.getMockFactory();
    }

    public static OkHttpClient.Builder enableTls12OnPreLollipop(OkHttpClient.Builder client) {
        if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 22) {
            try {
                SSLContext sc = SSLContext.getInstance("TLSv1.2");
                sc.init(null, null, null);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                Object[] trustManagers = trustManagerFactory.getTrustManagers();
                if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                    throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
                }
                X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
                client.sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(sc.getSocketFactory()), trustManager);
                ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
                ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
                specs.add(cs);
                client.connectionSpecs(specs);
            }
            catch (Exception exc) {
                Log.e((String)"OkHttpTLSCompat", (String)"Error while setting TLS 1.2", (Throwable)exc);
            }
        }
        return client;
    }

    @NonNull
    protected OkHttpClient.Builder createHttpClient(RestApiConfiguration configuration) {
        BasicAuthorization basicAuthorization;
        CertificatePinner certificatePinner;
        int timeout = configuration.getTimeout();
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, (long)timeout, TimeUnit.MILLISECONDS)).followSslRedirects(true).connectTimeout((long)timeout, TimeUnit.MILLISECONDS).readTimeout((long)timeout, TimeUnit.MILLISECONDS);
        ConnectionSpec connectionSpec = configuration.getConnectionSpec();
        if (connectionSpec != null) {
            clientBuilder.connectionSpecs(Collections.singletonList(connectionSpec));
        }
        if ((certificatePinner = configuration.getCertificatePinner()) != null) {
            clientBuilder.certificatePinner(certificatePinner);
        }
        if ((basicAuthorization = configuration.getBasicAuthorization()) != null) {
            clientBuilder.authenticator(new Authenticator(){

                public okhttp3.Request authenticate(Route route, Response response) throws IOException {
                    Request.Builder requestBuilder = response.request().newBuilder().header("Authorization", basicAuthorization.getBasicAuthorization());
                    return requestBuilder.build();
                }
            });
        }
        if (configuration.isEnableTls12OnPreLollipop()) {
            return Request.enableTls12OnPreLollipop(clientBuilder);
        }
        return clientBuilder;
    }

    protected RequestFuture<T> execute() {
        return this.execute(null);
    }

    protected RequestFuture<T> execute(@Nullable RequestListener<T> listener) {
        return this.execute(this.createRequestTask(), listener);
    }

    @NonNull
    protected RequestFuture<T> execute(Callable<T> task, @Nullable RequestListener<T> listener) {
        RequestFuture<T> future = this.executor.submit(task, this.ignoreErrorCallback ? null : this.getConfiguration().getErrorCallback(), listener);
        this.executor.shutdown();
        return future;
    }

    public void cancel() {
        this.executor.shutdownNow();
    }

    @NonNull
    protected Callable<T> createRequestTask() {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                Request.this.timer.start();
                Object result = Request.this.executeRequest();
                double time = Request.this.timer.getElapsedTime();
                if (time < (double)Request.this.minExecutionTime) {
                    try {
                        Thread.sleep((long)((double)Request.this.minExecutionTime - time));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!Request.this.disableLogging) {
                    Request.this.getLogger().vF("%s execution took: %.3fms", new Object[]{Request.this.getClassCodeAnchor(), Request.this.timer.getElapsedTime()});
                }
                return result;
            }
        };
    }

    protected T executeRequest() throws RequestException, IOException {
        this.checkInitialRequirements(this);
        T mock = this.mock();
        if (mock != null) {
            if (!this.disableLogging) {
                this.getLogger().i(new Object[]{"Mock response:", this.getClassCodeAnchor()});
            }
            return mock;
        }
        this.checkAccessToken();
        this.prepareRequest();
        HttpUrl url = this.getUrl();
        if (!this.disableLogging) {
            this.getLogger().v(new Object[]{"Start execution:", this.getClassCodeAnchor(), url});
        }
        Response response = this.request(url);
        T result = this.readResponse(response);
        response.close();
        return result;
    }

    @NonNull
    protected String getClassCodeAnchor() {
        Class<?> enclosingClass = this.getClass().getEnclosingClass();
        String name = enclosingClass != null ? enclosingClass.getSimpleName() : this.getClass().getSimpleName();
        return "(" + name + ".java:1)";
    }

    protected T mock() {
        return this.mockFactory == null ? null : (T)this.mockFactory.getMockResponse(this);
    }

    protected void checkInitialRequirements(Request<T> request) throws RequestException {
        try {
            InitialRequirements initialRequirements = this.getConfiguration().getInitialRequirements();
            if (initialRequirements != null) {
                initialRequirements.onCheckRequirements(request);
            }
        }
        catch (InitialRequirementsException e) {
            throw new RequestException(e);
        }
    }

    @WorkerThread
    protected void checkAccessToken() {
        if (!this.needAuthorization()) {
            return;
        }
        if (this.userService == null) {
            throw new UserServiceNotInitialized("Request is not properly configured to use UserService. Use method RestApi.Config.setRestAuthorizationService(RestAuthorizationService) to provide user service implementation");
        }
        if (!this.userService.isLogged() && !this.userService.onNotLogged(this)) {
            this.cancel();
            return;
        }
        LOCK.waitIfLocked();
        if (this.userService.isTokenValid()) {
            return;
        }
        LOCK.lock();
        try {
            this.userService.refreshToken();
        }
        catch (Exception e) {
            if (!this.userService.onRefreshTokenFailed(new RefreshTokenException("Problem during obtaining refresh token", e))) {
                this.cancel();
                return;
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    protected void ignoreErrorCallback() {
        this.ignoreErrorCallback = true;
    }

    protected boolean isErrorCallbackIgnored() {
        return this.ignoreErrorCallback;
    }

    protected void disableLogging() {
        this.disableLogging = true;
    }

    protected boolean isLoggingDisabled() {
        return this.ignoreErrorCallback;
    }

    protected void setIsAuthorizedRequest() {
        this.setIsAuthorizedRequest(true);
    }

    public void setIsAuthorizedRequest(boolean authorizedRequest) {
        this.authorizedRequest = authorizedRequest;
    }

    protected boolean needAuthorization() {
        return this.authorizedRequest || this instanceof Authorizable;
    }

    protected abstract void prepareRequest();

    @WorkerThread
    protected abstract Response request(HttpUrl var1) throws IOException;

    protected T readResponse(Response response) throws IOException, RequestException {
        if (response == null) {
            return null;
        }
        int status = response.code();
        String content = response.body().string();
        if (!this.disableLogging) {
            this.getLogger().v(new Object[]{"Response from:", this.getClassCodeAnchor() + "\n" + content});
        }
        if (this.isSuccess(response)) {
            Class<?> aClass = this.getClass();
            return this.getDeserializer().read(aClass, content);
        }
        throw this.getErrorDeserializer().read(status, content);
    }

    protected boolean isSuccess(Response response) {
        return this.getConfiguration().getSuccessStatusCodes().contains(response.code());
    }

    protected HttpUrl getUrl() {
        HttpUrl url;
        if (this.urlSegments == null) {
            throw new IllegalStateException("Set url in " + this.getClass().getSimpleName() + " prepareRequest method");
        }
        if (!TextUtils.isEmpty((CharSequence)this.url)) {
            String accessToken;
            if (this.needAuthorization() && this.userService != null && this.userService.getAuthorization() != null && !this.url.contains(accessToken = "access_token=" + this.userService.getAuthorization().getAccessToken())) {
                int questionMarkPosition = this.url.indexOf(63);
                char paramSeparator = questionMarkPosition >= 0 ? (char)'&' : '?';
                this.url = this.url + paramSeparator + accessToken;
            }
            url = HttpUrl.parse((String)this.url);
        } else {
            RestApiConfiguration configuration = this.getConfiguration();
            HttpUrl.Builder builder = new HttpUrl.Builder();
            builder.scheme(configuration.getScheme());
            if (configuration.getPort() >= 0) {
                builder.port(configuration.getPort());
            }
            builder.host(configuration.getHost());
            BasicAuthorization basicAuthorization = configuration.getBasicAuthorization();
            if (basicAuthorization != null) {
                builder.username(basicAuthorization.getUser()).password(basicAuthorization.getPassword());
            }
            for (String segment : this.urlSegments) {
                builder.addPathSegment(segment);
            }
            for (Parameter param : this.urlParameters) {
                builder.addQueryParameter(param.getName(), String.valueOf(param.getValue()));
            }
            if (this.needAuthorization() && this.userService != null && this.userService.getAuthorization() != null) {
                builder.addQueryParameter(ACCESS_TOKEN, this.userService.getAuthorization().getAccessToken());
            }
            url = builder.build();
        }
        return url;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    protected void setMinExecutionTime(long millis) {
        this.minExecutionTime = millis;
    }

    protected void setUrlSegments(String ... urlSegments) {
        this.urlSegments = urlSegments;
    }

    protected void putUrlParameter(@NonNull String name, @Nullable Object value) {
        this.getSerializer().serialize(this.urlParameters, name, value);
    }

    protected void putUrlParameter(@Nullable Object value) {
        this.getSerializer().serialize(this.urlParameters, value);
    }

    protected void putParameter(@NonNull String name, @Nullable Object value) {
        this.getSerializer().serialize(this.bodyParameters, name, value);
    }

    protected void putParameter(@Nullable Object value) {
        this.getSerializer().serialize(this.bodyParameters, value);
    }

    protected void addHeader(@NonNull String name, @NonNull String value) {
        this.headerMap.put(name, value);
    }

    protected Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(this.headerMap);
        headers.putAll(this.getConfiguration().getHeaders());
        return headers;
    }

    protected void removeParameter(@NonNull String key) {
        Iterator<Parameter> iterator = this.bodyParameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            if (!key.equals(parameter.getName())) continue;
            iterator.remove();
            return;
        }
    }

    protected void removeUrlParameter(@NonNull String key) {
        Iterator<Parameter> iterator = this.urlParameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            if (!key.equals(parameter.getName())) continue;
            iterator.remove();
            return;
        }
    }

    @Nullable
    protected RequestBody getRequestBody() {
        MediaType mediaType = this.getMediaType();
        if (MULTIPART_FORM_DATA.equals((Object)mediaType)) {
            return this.getMultipartBody();
        }
        if (APPLICATION_URLENCODED.equals((Object)mediaType)) {
            return this.getFormBody();
        }
        if (APPLICATION_JSON.equals((Object)mediaType)) {
            return this.getJsonBody();
        }
        throw new IllegalStateException("Unsupported media type: " + mediaType.toString());
    }

    protected boolean isMultipartRequest() {
        for (Parameter parameter : this.bodyParameters) {
            if (!parameter.isFile()) continue;
            return true;
        }
        return false;
    }

    @NonNull
    private RequestBody getMultipartBody() {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MULTIPART_FORM_DATA);
        Iterator<Parameter> iterator = this.bodyParameters.iterator();
        while (iterator.hasNext()) {
            File file;
            Parameter parameter = iterator.next();
            if (!parameter.isFile()) continue;
            String name = parameter.getName();
            String path = parameter.getFilePath();
            if (!this.disableLogging) {
                this.getLogger().d(new Object[]{name + ":", path});
            }
            if ((file = new File(path)).exists()) {
                bodyBuilder.addFormDataPart(name, file.getName(), RequestBody.create((MediaType)MediaType.parse((String)("image/" + this.getFileExtension(file))), (File)file));
            }
            iterator.remove();
        }
        for (Parameter parameter : this.bodyParameters) {
            String name = parameter.getName();
            String value = String.valueOf(parameter.getValue());
            if (!this.disableLogging) {
                this.getLogger().d(new Object[]{name + ":", value});
            }
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            bodyBuilder.addFormDataPart(name, value);
        }
        return bodyBuilder.build();
    }

    private String getFileExtension(@NonNull File file) {
        String fileName = file.getName();
        int beginIndex = fileName.lastIndexOf(".") + 1;
        if (beginIndex == 0) {
            return "*";
        }
        return fileName.substring(beginIndex);
    }

    @NonNull
    private RequestBody getFormBody() {
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        for (Parameter parameter : this.bodyParameters) {
            String name = parameter.getName();
            String value = String.valueOf(parameter.getValue());
            if (!this.disableLogging) {
                this.getLogger().d(new Object[]{name + ":", value});
            }
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            bodyBuilder.add(name, value);
        }
        return bodyBuilder.build();
    }

    private RequestBody getJsonBody() {
        if (this.getSerializer() instanceof JsonSerializer) {
            return RequestBody.create((MediaType)APPLICATION_JSON, (String)((JsonSerializer)this.getSerializer()).toJsonString(this.bodyParameters));
        }
        throw new IllegalStateException("Json media type requires JsonSerializer. Set JsonSerializer via RestApi.Config().setSerializer()");
    }

    protected MediaType getMediaType() {
        return this.isMultipartRequest() ? MULTIPART_FORM_DATA : this.mediaType;
    }

    protected Serializer getSerializer() {
        return this.getConfiguration().getSerializer();
    }

    protected Deserializer getDeserializer() {
        return this.getConfiguration().getDeserializer();
    }

    protected ErrorDeserializer getErrorDeserializer() {
        return this.getConfiguration().getErrorDeserializer();
    }

    protected Logger getLogger() {
        return this.getConfiguration().getLogger();
    }

    protected boolean isConfigured() {
        return this.getConfiguration() != null;
    }

    protected RestApiConfiguration getConfiguration() {
        return RestApi.getConfiguration();
    }
}

