/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.Nullable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.restapi.PoolRequest;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RestApi;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.RequestPoolListener;

class SerialPoolRequest
extends PoolRequest<SerialPoolRequest> {
    @Nullable
    private RequestPoolListener listener;
    private Map<Integer, Object> results = new LinkedHashMap<Integer, Object>();
    private Iterator<Map.Entry<Integer, Request>> executeIterator;

    public SerialPoolRequest() {
        super(1);
    }

    @Override
    public void execute(@Nullable RequestPoolListener listener) {
        if (this.executed) {
            throw new IllegalStateException("Already executed.");
        }
        this.executed = true;
        this.executeIterator = this.requestPool.entrySet().iterator();
        this.listener = listener;
        if (this.listener != null) {
            this.listener.onPreExecute();
        }
        this.executeNext();
    }

    private void executeNext() {
        if (!this.cancelled && this.executeIterator.hasNext()) {
            Map.Entry<Integer, Request> requestEntry = this.executeIterator.next();
            this.executor.submit(requestEntry.getValue().createRequestTask(), requestEntry.getValue().isErrorCallbackIgnored() ? null : RestApi.getConfiguration().getErrorCallback(), new PoolRequest.PoolRequestListener((int)requestEntry.getKey()){

                public void onSuccess(Object result) {
                    int requestCode = this.getRequestCode();
                    SerialPoolRequest.this.results.put(requestCode, result);
                    if (SerialPoolRequest.this.listener != null) {
                        SerialPoolRequest.this.listener.onTaskSuccess(result, requestCode);
                    }
                    SerialPoolRequest.this.executeNext();
                }

                @Override
                public void onFailed(RequestException e) {
                    int requestCode = this.getRequestCode();
                    if (SerialPoolRequest.this.listener == null || !SerialPoolRequest.this.listener.onFailed(e, requestCode)) {
                        SerialPoolRequest.this.results.put(requestCode, null);
                        SerialPoolRequest.this.executeNext();
                    }
                }

                @Override
                public void onCancel() {
                    int requestCode = this.getRequestCode();
                    SerialPoolRequest.this.cancelled = true;
                    SerialPoolRequest.this.results.put(requestCode, null);
                    SerialPoolRequest.this.executeNext();
                }
            });
        } else {
            this.stopExecute();
            if (this.listener != null) {
                if (this.cancelled) {
                    this.listener.onCancel();
                } else {
                    if (this.results.size() == this.requestPool.size()) {
                        this.listener.onSuccess(this.results);
                    }
                    this.listener.onPostExecute();
                }
            }
        }
    }
}

