/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import software.rsquared.restapi.RequestFuture;
import software.rsquared.restapi.exceptions.AccessTokenException;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.ErrorCallback;
import software.rsquared.restapi.listeners.RequestListener;

class RequestFutureTask<T>
extends FutureTask<T>
implements RequestFuture<T> {
    private final ErrorCallback errorCallback;
    @Nullable
    private RequestListener<T> listener;
    @Nullable
    private static Handler handler;

    RequestFutureTask(@NonNull Callable<T> callable, @Nullable ErrorCallback errorCallback) {
        super(callable);
        this.errorCallback = errorCallback;
    }

    RequestFutureTask(@NonNull Callable<T> callable, ErrorCallback errorCallback, @Nullable RequestListener<T> listener) {
        super(callable);
        this.errorCallback = errorCallback;
        this.listener = listener;
    }

    @Override
    public T get() throws RequestException {
        try {
            return (T)super.get();
        }
        catch (InterruptedException | ExecutionException | AccessTokenException e) {
            throw this.parseException(e);
        }
    }

    @Override
    public T get(long timeout, @NonNull TimeUnit unit) throws RequestException {
        try {
            return (T)super.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException | AccessTokenException e) {
            RequestException exception = this.parseException(e);
            if (this.errorCallback != null) {
                this.errorCallback.onError(exception);
            }
            throw exception;
        }
    }

    @Override
    public void run() {
        if (this.listener != null) {
            this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    RequestFutureTask.this.listener.onPreExecute();
                }
            });
        }
        super.run();
    }

    @Override
    protected void done() {
        if (this.listener != null) {
            this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        RequestFutureTask.this.listener.onSuccess(RequestFutureTask.this.get());
                    }
                    catch (RequestException e) {
                        RequestFutureTask.this.listener.onFailed(e);
                    }
                    RequestFutureTask.this.listener.onPostExecute();
                }
            });
        }
        super.done();
    }

    @NonNull
    private RequestException parseException(Exception e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            if (cause instanceof RequestException) {
                return (RequestException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
        }
        return new RequestException(e);
    }

    @NonNull
    private Handler getHandler() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        return handler;
    }
}

