/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.restapi.PoolRequest;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.RequestPoolListener;

class ThreadPoolRequest
extends PoolRequest<ThreadPoolRequest> {
    private Map<Integer, Object> mResults = new LinkedHashMap<Integer, Object>();
    private RequestPoolListener mListener;

    public ThreadPoolRequest(int poolSize) {
        super(poolSize);
    }

    @Override
    public void execute(RequestPoolListener listener) {
        if (this.mExecuted) {
            throw new IllegalStateException("Already executed.");
        }
        this.mExecuted = true;
        this.mListener = listener;
        if (this.mListener != null) {
            this.mListener.onPreExecute();
        }
        for (Map.Entry entry : this.mRequestPool.entrySet()) {
            this.mExecutor.submit(((Request)entry.getValue()).createRequestTask(), new PoolRequest.PoolRequestListener((int)((Integer)entry.getKey())){

                public void onSuccess(Object result) {
                    int requestCode = this.getRequestCode();
                    ThreadPoolRequest.this.mResults.put(requestCode, result);
                    if (ThreadPoolRequest.this.mListener != null) {
                        ThreadPoolRequest.this.mListener.onTaskSuccess(result, requestCode);
                    }
                    this.checkFinished();
                }

                @Override
                public void onFailed(RequestException e) {
                    int requestCode = this.getRequestCode();
                    if (ThreadPoolRequest.this.mListener != null && ThreadPoolRequest.this.mListener.onFailed(e, requestCode)) {
                        ThreadPoolRequest.this.stopExecute();
                    } else {
                        ThreadPoolRequest.this.mResults.put(requestCode, null);
                    }
                    this.checkFinished();
                }

                private void checkFinished() {
                    if (ThreadPoolRequest.this.mResults.size() == ThreadPoolRequest.this.mRequestPool.size()) {
                        ThreadPoolRequest.this.stopExecute();
                        if (ThreadPoolRequest.this.mListener != null) {
                            ThreadPoolRequest.this.mListener.onSuccess(ThreadPoolRequest.this.mResults);
                            ThreadPoolRequest.this.mListener.onPreExecute();
                        }
                    }
                }
            });
        }
        this.mExecutor.shutdown();
    }
}

