/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.restapi.PoolRequest;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.RequestPoolListener;

class SerialPoolRequest
extends PoolRequest<SerialPoolRequest> {
    private RequestPoolListener mListener;
    private Map<Integer, Object> mResults = new LinkedHashMap<Integer, Object>();
    private Iterator<Map.Entry<Integer, Request>> mExecuteIterator;

    public SerialPoolRequest() {
        super(1);
    }

    @Override
    public void execute(RequestPoolListener listener) {
        if (this.mExecuted) {
            throw new IllegalStateException("Already executed.");
        }
        this.mExecuted = true;
        this.mExecuteIterator = this.mRequestPool.entrySet().iterator();
        this.mListener = listener;
        if (this.mListener != null) {
            this.mListener.onPreExecute();
        }
        this.executeNext();
    }

    private void executeNext() {
        if (this.mExecuteIterator.hasNext()) {
            Map.Entry<Integer, Request> requestEntry = this.mExecuteIterator.next();
            this.mExecutor.submit(requestEntry.getValue().createRequestTask(), new PoolRequest.PoolRequestListener((int)requestEntry.getKey()){

                public void onSuccess(Object result) {
                    int requestCode = this.getRequestCode();
                    SerialPoolRequest.this.mResults.put(requestCode, result);
                    if (SerialPoolRequest.this.mListener != null) {
                        SerialPoolRequest.this.mListener.onTaskSuccess(result, requestCode);
                    }
                    SerialPoolRequest.this.executeNext();
                }

                @Override
                public void onFailed(RequestException e) {
                    int requestCode = this.getRequestCode();
                    if (SerialPoolRequest.this.mListener == null || !SerialPoolRequest.this.mListener.onFailed(e, requestCode)) {
                        SerialPoolRequest.this.mResults.put(requestCode, null);
                        SerialPoolRequest.this.executeNext();
                    }
                }
            });
        } else {
            this.stopExecute();
            if (this.mListener != null) {
                if (this.mResults.size() == this.mRequestPool.size()) {
                    this.mListener.onSuccess(this.mResults);
                }
                this.mListener.onPostExecute();
            }
        }
    }
}

