/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import software.rsquared.restapi.RequestFuture;
import software.rsquared.restapi.RequestFutureTask;
import software.rsquared.restapi.listeners.RequestListener;

class RequestExecutor
extends ThreadPoolExecutor {
    RequestExecutor() {
        this(1, 0L);
    }

    RequestExecutor(int poolSize, long aliveDuration) {
        super(poolSize, poolSize, aliveDuration, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public RequestExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public RequestExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public RequestExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public RequestExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @NonNull
    <T> RequestFuture<T> submit(@NonNull Callable<T> task, @Nullable RequestListener<T> listener) {
        RequestFutureTask<T> futureTask = new RequestFutureTask<T>(task, listener);
        this.execute(futureTask);
        return futureTask;
    }

    @NonNull
    public <T> RequestFuture<T> submit(@NonNull Callable<T> task) {
        RequestFutureTask<T> futureTask = new RequestFutureTask<T>(task);
        this.execute(futureTask);
        return futureTask;
    }

    @Override
    @Deprecated
    @NonNull
    public Future<?> submit(Runnable task) {
        throw new RuntimeException("Method not supported!");
    }

    @Override
    @Deprecated
    @NonNull
    public <T> Future<T> submit(Runnable task, T result) {
        throw new RuntimeException("Method not supported!");
    }
}

