/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import software.rsquared.restapi.Authorizable;
import software.rsquared.restapi.BasicAuthorization;
import software.rsquared.restapi.InitialRequirements;
import software.rsquared.restapi.Parameter;
import software.rsquared.restapi.RequestExecutor;
import software.rsquared.restapi.RequestFuture;
import software.rsquared.restapi.RestApi;
import software.rsquared.restapi.RestAuthorizationService;
import software.rsquared.restapi.ThreadLock;
import software.rsquared.restapi.Timer;
import software.rsquared.restapi.exceptions.AccessTokenException;
import software.rsquared.restapi.exceptions.InitialRequirementsException;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.RequestListener;
import software.rsquared.restapi.serialization.Deserializer;
import software.rsquared.restapi.serialization.ErrorDeserializer;
import software.rsquared.restapi.serialization.Serializer;

public abstract class Request<T> {
    public static final MediaType MULTIPART_FORM_DATA = MediaType.parse((String)"multipart/form-data");
    public static final MediaType APPLICATION_URLENCODED = MediaType.parse((String)"application/x-www-form-urlencoded");
    protected static final String ACCESS_TOKEN = "access_token";
    protected static final String AUTHORIZATION = "BasicAuthorization";
    protected static final String CONTENT_TYPE = "Content-Type";
    private static final ThreadLock LOCK = new ThreadLock();
    protected final OkHttpClient mHttpClient;
    private final RequestExecutor mExecutor;
    private final List<Parameter> mBodyParameters = new ArrayList<Parameter>();
    private final List<Parameter> mUrlParameters = new ArrayList<Parameter>();
    private final Map<String, String> mHeaderMap = new HashMap<String, String>();
    private final Timer mTimer = new Timer();
    private MediaType mMediaType = APPLICATION_URLENCODED;
    private String[] mUrlSegments;
    private String mUrl;
    private long mMinExecutionTime;
    private boolean mAuthorizedRequest;
    private RestAuthorizationService mUserService;

    protected Request() {
        if (!RestApi.isConfigured()) {
            throw new IllegalStateException("RestApi must be configured before using requests");
        }
        this.mHttpClient = this.createHttpClient();
        this.mExecutor = new RequestExecutor(1, RestApi.getConfiguration().getTimeout());
        this.mUserService = RestApi.getConfiguration().getRestAuthorizationService();
    }

    @NonNull
    private OkHttpClient createHttpClient() {
        int timeout = RestApi.getConfiguration().getTimeout();
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, (long)timeout, TimeUnit.MILLISECONDS)).connectTimeout((long)timeout, TimeUnit.MILLISECONDS).readTimeout((long)timeout, TimeUnit.MILLISECONDS);
        final BasicAuthorization basicAuthorization = RestApi.getConfiguration().getBasicAuthorization();
        if (basicAuthorization != null) {
            clientBuilder.authenticator(new Authenticator(){

                public okhttp3.Request authenticate(Route route, Response response) throws IOException {
                    Request.Builder requestBuilder = response.request().newBuilder().header("Authorization", basicAuthorization.getBasicAuthorization());
                    return requestBuilder.build();
                }
            });
        }
        return clientBuilder.build();
    }

    RequestFuture<T> execute() {
        return this.execute(null);
    }

    RequestFuture<T> execute(RequestListener<T> listener) {
        return this.execute(this.createRequestTask(), listener);
    }

    @NonNull
    private RequestFuture<T> execute(Callable<T> task, RequestListener<T> listener) {
        RequestFuture<T> future = this.mExecutor.submit(task, listener);
        this.mExecutor.shutdown();
        return future;
    }

    public void cancel() {
        this.mExecutor.shutdownNow();
    }

    @NonNull
    protected Callable<T> createRequestTask() {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                Request.this.mTimer.start();
                Object result = Request.this.executeRequest();
                double time = Request.this.mTimer.getElapsedTime();
                if (time < (double)Request.this.mMinExecutionTime) {
                    try {
                        Thread.sleep((long)((double)Request.this.mMinExecutionTime - time));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                RestApi.getLogger().vF("%s execution took: %.3fms", new Object[]{Request.this.getClassCodeAnchor(), Request.this.mTimer.getElapsedTime()});
                return result;
            }
        };
    }

    protected T executeRequest() throws RequestException, IOException {
        this.checkInitialRequirements(this);
        T mock = this.mock();
        if (mock != null) {
            RestApi.getLogger().i(new Object[]{"Mock response:", this.getClassCodeAnchor()});
            return mock;
        }
        this.checkAccessToken();
        this.prepareRequest();
        HttpUrl url = this.getUrl();
        RestApi.getLogger().v(new Object[]{"Start execution:", this.getClassCodeAnchor(), url});
        Response response = this.request(url);
        T result = this.readResponse(response);
        response.close();
        return result;
    }

    @NonNull
    protected String getClassCodeAnchor() {
        Class<?> enclosingClass = this.getClass().getEnclosingClass();
        String name = enclosingClass != null ? enclosingClass.getSimpleName() : this.getClass().getSimpleName();
        return "(" + name + ".java:1)";
    }

    protected T mock() {
        return null;
    }

    protected void checkInitialRequirements(Request<T> request) throws RequestException {
        try {
            InitialRequirements initialRequirements = RestApi.getConfiguration().getInitialRequirements();
            if (initialRequirements != null) {
                initialRequirements.onCheckRequirements(request);
            }
        }
        catch (InitialRequirementsException e) {
            throw new RequestException(e);
        }
    }

    @WorkerThread
    protected void checkAccessToken() {
        if (!this.needAuthorization()) {
            return;
        }
        if (this.mUserService == null) {
            throw new IllegalArgumentException("Request is not properly configured to use UserService. Use method RestApi.Config.setRestAuthorizationService(RestAuthorizationService) to provide user service implementation");
        }
        if (!this.mUserService.isLogged()) {
            throw new AccessTokenException(this.getClass().getSimpleName() + " required user to be logged in.");
        }
        try {
            LOCK.waitIfLocked();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Locked thread interrupted!", e);
        }
        if (this.mUserService.isTokenValid()) {
            return;
        }
        try {
            LOCK.lock();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Locked thread interrupted!", e);
        }
        try {
            this.mUserService.refreshToken();
        }
        catch (Exception e) {
            this.mUserService.logout();
            throw new AccessTokenException("Problem during obtaining refresh token", e);
        }
        finally {
            LOCK.unlock();
        }
    }

    public void setIsAuthorizedRequest() {
        this.setIsAuthorizedRequest(true);
    }

    public void setIsAuthorizedRequest(boolean authorizedRequest) {
        this.mAuthorizedRequest = authorizedRequest;
    }

    protected boolean needAuthorization() {
        return this.mAuthorizedRequest || this instanceof Authorizable;
    }

    protected abstract void prepareRequest();

    @WorkerThread
    protected abstract Response request(HttpUrl var1) throws IOException;

    protected T readResponse(Response response) throws IOException, RequestException {
        if (response == null) {
            return null;
        }
        int status = response.code();
        String content = response.body().string();
        RestApi.getLogger().v(new Object[]{"Response from:", this.getClassCodeAnchor() + "\n" + content});
        if (this.isSuccess(response)) {
            Class<?> aClass = this.getClass();
            return this.getDeserializer().read(aClass, content);
        }
        throw this.getErrorDeserializer().read(status, content);
    }

    protected boolean isSuccess(Response response) {
        return response.code() == 200;
    }

    protected HttpUrl getUrl() {
        HttpUrl url;
        if (this.mUrlSegments == null) {
            throw new IllegalStateException("Set url in " + this.getClass().getSimpleName() + " prepareRequest method");
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUrl)) {
            String accessToken;
            if (this.needAuthorization() && this.mUserService != null && this.mUserService.getAuthorization() != null && !this.mUrl.contains(accessToken = "access_token=" + this.mUserService.getAuthorization().getAccessToken())) {
                int questionMarkPosition = this.mUrl.indexOf(63);
                char paramSeparator = questionMarkPosition >= 0 ? (char)'&' : '?';
                this.mUrl = this.mUrl + paramSeparator + accessToken;
            }
            url = HttpUrl.parse((String)this.mUrl);
        } else {
            HttpUrl.Builder builder = new HttpUrl.Builder();
            builder.scheme(RestApi.getConfiguration().getScheme());
            if (RestApi.getConfiguration().getPort() >= 0) {
                builder.port(RestApi.getConfiguration().getPort());
            }
            builder.host(RestApi.getConfiguration().getHost());
            BasicAuthorization basicAuthorization = RestApi.getConfiguration().getBasicAuthorization();
            if (basicAuthorization != null) {
                builder.username(basicAuthorization.getUser()).password(basicAuthorization.getPassword());
            }
            for (String segment : this.mUrlSegments) {
                builder.addPathSegment(segment);
            }
            for (Parameter param : this.mUrlParameters) {
                builder.addQueryParameter(param.getName(), String.valueOf(param.getValue()));
            }
            if (this.needAuthorization() && this.mUserService != null && this.mUserService.getAuthorization() != null) {
                builder.addQueryParameter(ACCESS_TOKEN, this.mUserService.getAuthorization().getAccessToken());
            }
            url = builder.build();
        }
        return url;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public void setMinExecutionTime(long millis) {
        this.mMinExecutionTime = millis;
    }

    protected void setUrlSegments(String ... urlSegments) {
        this.mUrlSegments = urlSegments;
    }

    protected void putUrlParameter(@NonNull String name, @Nullable Object value) {
        this.mUrlParameters.addAll(this.getSerializer().serialize(name, value));
    }

    protected void putUrlParameter(@Nullable Object value) {
        this.mUrlParameters.addAll(this.getSerializer().serialize(value));
    }

    protected void putParameter(@NonNull String name, @Nullable Object value) {
        this.mBodyParameters.addAll(this.getSerializer().serialize(name, value));
    }

    protected void putParameter(@Nullable Object value) {
        this.mBodyParameters.addAll(this.getSerializer().serialize(value));
    }

    protected void addHeader(@NonNull String name, @NonNull String value) {
        this.mHeaderMap.put(name, value);
    }

    protected Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(this.mHeaderMap);
        headers.putAll(RestApi.getConfiguration().getHeaders());
        return headers;
    }

    protected void removeParameter(@NonNull String key) {
        Iterator<Parameter> iterator = this.mBodyParameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            if (!key.equals(parameter.getName())) continue;
            iterator.remove();
            return;
        }
    }

    protected void removeUrlParameter(@NonNull String key) {
        Iterator<Parameter> iterator = this.mUrlParameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            if (!key.equals(parameter.getName())) continue;
            iterator.remove();
            return;
        }
    }

    @Nullable
    protected RequestBody getRequestBody() {
        RequestBody body = this.isMultipartRequest() ? this.getMultipartBody() : this.getFormBody();
        return body;
    }

    protected boolean isMultipartRequest() {
        for (Parameter parameter : this.mBodyParameters) {
            if (!parameter.isFile()) continue;
            return true;
        }
        return false;
    }

    @NonNull
    private RequestBody getMultipartBody() {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MULTIPART_FORM_DATA);
        Iterator<Parameter> iterator = this.mBodyParameters.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            if (!parameter.isFile()) continue;
            String name = parameter.getName();
            String path = parameter.getFilePath();
            RestApi.getLogger().d(new Object[]{name + ":", path});
            File file = new File(path);
            if (file.exists()) {
                bodyBuilder.addFormDataPart(name, file.getName(), RequestBody.create((MediaType)MediaType.parse((String)("image/" + this.getFileExtension(file))), (File)file));
            }
            iterator.remove();
        }
        for (Parameter parameter : this.mBodyParameters) {
            String name = parameter.getName();
            String value = String.valueOf(parameter.getValue());
            RestApi.getLogger().d(new Object[]{name + ":", value});
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            bodyBuilder.addFormDataPart(name, value);
        }
        return bodyBuilder.build();
    }

    private String getFileExtension(@NonNull File file) {
        String fileName = file.getName();
        int beginIndex = fileName.lastIndexOf(".") + 1;
        if (beginIndex == 0) {
            return "*";
        }
        return fileName.substring(beginIndex);
    }

    @NonNull
    private RequestBody getFormBody() {
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        for (Parameter parameter : this.mBodyParameters) {
            String name = parameter.getName();
            String value = String.valueOf(parameter.getValue());
            RestApi.getLogger().d(new Object[]{name + ":", value});
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            bodyBuilder.add(name, value);
        }
        return bodyBuilder.build();
    }

    protected MediaType getMediaType() {
        return this.isMultipartRequest() ? MULTIPART_FORM_DATA : this.mMediaType;
    }

    protected Serializer getSerializer() {
        return RestApi.getConfiguration().getSerializer();
    }

    protected Deserializer getDeserializer() {
        return RestApi.getConfiguration().getDeserializer();
    }

    protected ErrorDeserializer getErrorDeserializer() {
        return RestApi.getConfiguration().getErrorDeserializer();
    }
}

