/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.NonNull;
import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RequestExecutor;
import software.rsquared.restapi.listeners.RequestListener;
import software.rsquared.restapi.listeners.RequestPoolListener;

abstract class PoolRequest<P extends PoolRequest> {
    protected Map<Integer, Request> mRequestPool = new LinkedHashMap<Integer, Request>();
    protected boolean mExecuted;
    protected RequestExecutor mExecutor;

    protected PoolRequest(int poolSize) {
        this.mExecutor = new RequestExecutor(poolSize, 0L);
    }

    public P addTask(@NonNull Request request, int requestCode) {
        if (this.mExecuted) {
            throw new IllegalStateException("New task cannot be added to the pool after executing.");
        }
        if (this.mRequestPool.containsKey(requestCode)) {
            throw new IllegalArgumentException("Task with this requestCode (" + requestCode + ") was already added.");
        }
        this.mRequestPool.put(requestCode, request);
        return (P)this;
    }

    public abstract void execute(RequestPoolListener var1);

    public void stopExecute() {
        this.mExecutor.shutdownNow();
    }

    abstract class PoolRequestListener
    extends RequestListener {
        private int mRequestCode;

        public PoolRequestListener(int requestCode) {
            this.mRequestCode = requestCode;
        }

        public int getRequestCode() {
            return this.mRequestCode;
        }
    }
}

