/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.s3accessgrants.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.s3accessgrants.cache.CacheKey;
import software.amazon.awssdk.services.s3control.model.S3ControlException;

public class S3AccessGrantsAccessDeniedCache {
    private Cache<CacheKey, S3ControlException> cache;
    private int maxCacheSize = 3000;

    private S3AccessGrantsAccessDeniedCache() {
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    protected S3ControlException getValueFromCache(CacheKey cacheKey) {
        return (S3ControlException)((Object)this.cache.getIfPresent((Object)cacheKey));
    }

    protected void putValueInCache(CacheKey cacheKey, S3ControlException exception) {
        this.cache.put((Object)cacheKey, (Object)exception);
    }

    void invalidateCache() {
        this.cache.invalidateAll();
    }

    protected CacheStats getCacheStats() {
        return this.cache.stats();
    }

    static final class BuilderImpl
    implements Builder {
        private int maxCacheSize = 3000;

        private BuilderImpl() {
        }

        @Override
        public S3AccessGrantsAccessDeniedCache build() {
            S3AccessGrantsAccessDeniedCache s3AccessGrantsAccessDeniedCache = new S3AccessGrantsAccessDeniedCache();
            s3AccessGrantsAccessDeniedCache.maxCacheSize = this.maxCacheSize();
            s3AccessGrantsAccessDeniedCache.cache = Caffeine.newBuilder().maximumSize((long)this.maxCacheSize).expireAfterWrite(5L, TimeUnit.MINUTES).recordStats().build();
            return s3AccessGrantsAccessDeniedCache;
        }

        @Override
        public Builder maxCacheSize(int maxCacheSize) {
            if (maxCacheSize <= 0 || maxCacheSize > 1000000) {
                throw new IllegalArgumentException(String.format("maxCacheSize needs to be in range (0, %d]", 1000000));
            }
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        public int maxCacheSize() {
            return this.maxCacheSize;
        }
    }

    public static interface Builder {
        public S3AccessGrantsAccessDeniedCache build();

        public Builder maxCacheSize(int var1);
    }
}

