/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.dp;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.Expression;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import com.amazonaws.services.dynamodbv2.rr.ExpressionWrapper;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBOutputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.Mutation;
import software.amazon.dynamodb.services.local.shared.access.api.dp.WriteDataPlaneFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.helpers.TransactionsEnabledMode;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.model.Condition;
import software.amazon.dynamodb.services.local.shared.model.ExpectedAttributeValue;

public class PutItemFunction
extends WriteDataPlaneFunction<PutItemRequest, PutItemResponse> {
    public PutItemFunction(LocalDBAccess dbAccess, DbEnv localDBEnv, LocalDBInputConverter inputConverter, LocalDBOutputConverter localDBOutputConverter, AWSExceptionFactory awsExceptionFactory, DocumentFactory documentFactory, TransactionsEnabledMode transactionsEnabledMode) {
        super(dbAccess, localDBEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, documentFactory, transactionsEnabledMode);
    }

    @Override
    public PutItemResponse apply(PutItemRequest rawPutItemRequest) {
        String unparsedTableName = rawPutItemRequest.tableName();
        final String tableName = this.getTableNameFromPossibleArn(unparsedTableName);
        final PutItemRequest putItemRequest = (PutItemRequest)rawPutItemRequest.toBuilder().tableName(tableName).build();
        this.validateTableName(tableName);
        final TableInfo tableInfo = this.validateTableExists(tableName);
        final ReturnValue returnVals = this.validateReturnType(putItemRequest.returnValuesAsString(), false);
        LocalDBValidatorUtils.validateExpressions(putItemRequest, this.inputConverter);
        if (putItemRequest.item() == null || !putItemRequest.hasItem()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_PUT_NULL.getMessage());
        }
        final Map record = (Map)this.inputConverter.externalToInternalAttributes(putItemRequest.item());
        final Map key = this.validatePutItem(record, tableInfo);
        final Map<String, ExpectedAttributeValue> expected = this.inputConverter.externalToInternalExpectedAttributes(putItemRequest.hasExpected() ? putItemRequest.expected() : null, 409600);
        final PutItemResponse.Builder putResponse = PutItemResponse.builder();
        String conditionExpressionString = putItemRequest.conditionExpression();
        final String returnValuesOnConditionCheckFailure = LocalDBValidatorUtils.validateReturnValuesOnConditionCheckFailure(putItemRequest.returnValuesOnConditionCheckFailureAsString());
        String conditionalOperatorAsString = putItemRequest.conditionalOperatorAsString();
        this.validateExpectations(expected, conditionalOperatorAsString);
        final ReturnConsumedCapacity returnConsumedCapacity = this.convertReturnConsumedCapacity(putItemRequest.returnConsumedCapacityAsString());
        if (conditionExpressionString == null && expected.isEmpty()) {
            new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

                @Override
                public void criticalSection() {
                    PutItemFunction.this.putItemNoCondition(tableName, tableInfo, returnVals, record, key, putResponse, returnConsumedCapacity);
                }
            }.execute();
        } else if (conditionExpressionString != null) {
            ExpressionWrapper conditionExpressionWrapper = this.inputConverter.externalToInternalConditionExpression(conditionExpressionString, putItemRequest.expressionAttributeNames(), putItemRequest.expressionAttributeValues());
            final Expression conditionExpression = conditionExpressionWrapper == null ? null : conditionExpressionWrapper.getExpression();
            LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, conditionExpressionWrapper, this.awsExceptionFactory);
            new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

                @Override
                public void criticalSection() {
                    PutItemFunction.this.putItemWithConditionExpression(tableName, tableInfo, returnVals, record, key, conditionExpression, putResponse, returnConsumedCapacity, returnValuesOnConditionCheckFailure);
                }
            }.execute();
        } else {
            new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

                @Override
                public void criticalSection() {
                    PutItemFunction.this.putItemConditionalOperator(putItemRequest, tableName, tableInfo, returnVals, record, key, expected, putResponse, returnConsumedCapacity, returnValuesOnConditionCheckFailure);
                }
            }.execute();
        }
        return (PutItemResponse)putResponse.build();
    }

    void putItemWithConditionExpression(String tableName, TableInfo tableInfo, ReturnValue returnVals, Map<String, AttributeValue> record, Map<String, AttributeValue> key, Expression conditionExpression, PutItemResponse.Builder putResponse, ReturnConsumedCapacity returnConsumedCapacity, String returnValuesOnConditionCheckFailure) {
        Map<String, AttributeValue> oldItem = this.dbAccess.getRecord(tableName, key);
        if (conditionExpression != null && !LocalDBUtils.doesItemMatchCondition(oldItem, conditionExpression, this.localDBEnv, this.documentFactory)) {
            if (this.getReturnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure).equals((Object)ReturnValuesOnConditionCheckFailure.ALL_OLD)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CONDITIONAL_CHECK_FAILED.getMessage(), oldItem);
            }
            this.awsExceptionFactory.CONDITIONAL_CHECK_FAILED.throwAsException();
        }
        AttributeValue rangeKey = null;
        if (tableInfo != null && tableInfo.hasRangeKey()) {
            rangeKey = key.get(tableInfo.getRangeKey().attributeName());
        }
        this.dbAccess.putRecord(tableName, record, key.get(tableInfo.getHashKey().attributeName()), rangeKey, false);
        if (returnVals == ReturnValue.ALL_OLD) {
            putResponse.attributes(this.localDBOutputConverter.internalToExternalAttributes(oldItem));
        }
        putResponse.consumedCapacity(this.computeWriteCapacity(tableName, new Mutation(oldItem, record), returnConsumedCapacity, this.transactionsMode));
    }

    private void putItemConditionalOperator(PutItemRequest putItemRequest, String tableName, TableInfo tableInfo, ReturnValue returnVals, Map<String, AttributeValue> record, Map<String, AttributeValue> key, Map<String, ExpectedAttributeValue> expected, PutItemResponse.Builder putResponse, ReturnConsumedCapacity returnConsumedCapacity, String returnValuesOnConditionCheckFailure) {
        Map<String, AttributeValue> oldItem = this.dbAccess.getRecord(tableName, key);
        String conditionalOperatorAsString = putItemRequest.conditionalOperatorAsString();
        this.validateExpectations(expected, conditionalOperatorAsString);
        Map<String, Condition> conditions = this.convertToConditions(expected);
        this.validateConditions(conditions, conditionalOperatorAsString);
        if (!this.doesItemMatchConditionalOperator(oldItem, conditions, this.conditionalOperatorFrom(conditionalOperatorAsString))) {
            if (this.getReturnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure).equals((Object)ReturnValuesOnConditionCheckFailure.ALL_OLD)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CONDITIONAL_CHECK_FAILED.getMessage(), oldItem);
            }
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CONDITIONAL_CHECK_FAILED.getMessage());
        }
        AttributeValue rangeKey = null;
        if (tableInfo.hasRangeKey()) {
            rangeKey = key.get(tableInfo.getRangeKey().attributeName());
        }
        this.dbAccess.putRecord(tableName, record, key.get(tableInfo.getHashKey().attributeName()), rangeKey, false);
        if (returnVals == ReturnValue.ALL_OLD) {
            putResponse.attributes(this.localDBOutputConverter.internalToExternalAttributes(oldItem));
        }
        putResponse.consumedCapacity(this.computeWriteCapacity(tableName, new Mutation(oldItem, record), returnConsumedCapacity, this.transactionsMode));
    }

    void putItemNoCondition(String tableName, TableInfo tableInfo, ReturnValue returnVals, Map<String, AttributeValue> record, Map<String, AttributeValue> key, PutItemResponse.Builder putResponse, ReturnConsumedCapacity returnConsumedCapacity) {
        Map<String, AttributeValue> oldItem = this.dbAccess.getRecord(tableName, key);
        AttributeValue rangeKey = null;
        if (tableInfo.hasRangeKey()) {
            rangeKey = key.get(tableInfo.getRangeKey().attributeName());
        }
        this.dbAccess.putRecord(tableName, record, key.get(tableInfo.getHashKey().attributeName()), rangeKey, false);
        if (returnVals == ReturnValue.ALL_OLD) {
            putResponse.attributes(this.localDBOutputConverter.internalToExternalAttributes(oldItem));
        }
        putResponse.consumedCapacity(this.computeWriteCapacity(tableName, new Mutation(oldItem, record), returnConsumedCapacity, this.transactionsMode));
    }
}

