/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access;

import com.amazonaws.services.dynamodbv2.datamodel.DocPathElement;
import com.amazonaws.services.dynamodbv2.datamodel.UpdateExpression;
import com.amazonaws.services.dynamodbv2.datamodel.UpdateTreeNode;
import com.amazonaws.services.dynamodbv2.rr.ExpressionsWrapperBase;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.LocalDBComparisonOperator;
import software.amazon.dynamodb.services.local.shared.access.DDBType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.UnsignedByteArrayComparator;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.helpers.ExpressionUtils;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.validate.ErrorFactory;

public class LocalDBValidatorUtils {
    public static void validateArgumentsForComparisonOperator(ComparisonOperator op, List<AttributeValue> attributeValues, ErrorFactory errorFactory) {
        int numberOfAttributes;
        LocalDBComparisonOperator operation = LocalDBComparisonOperator.valueOf(op.toString());
        int n = numberOfAttributes = attributeValues == null ? 0 : attributeValues.size();
        if (!operation.isValidAttributeCount(numberOfAttributes)) {
            errorFactory.INVALID_PARAMETER_VALUE.throwAsException("Invalid number of argument(s) for the " + operation + " ComparisonOperator");
        }
        if (numberOfAttributes > 0) {
            DDBType firstType = null;
            for (AttributeValue val : attributeValues) {
                if (firstType == null) {
                    firstType = val.getType();
                }
                if (!operation.isTypeSupported(val.getType())) {
                    errorFactory.INVALID_PARAMETER_VALUE.throwAsException("ComparisonOperator " + operation + " is not valid for " + val.getType() + " AttributeValue type");
                }
                if (val.getType() == firstType) continue;
                errorFactory.INVALID_PARAMETER_VALUE.throwAsException("AttributeValues inside AttributeValueList must be of same type");
            }
        }
        if (operation == LocalDBComparisonOperator.BETWEEN && UnsignedByteArrayComparator.compareUnsignedByteArrays(attributeValues.get(0).getRawScalarValue(), attributeValues.get(1).getRawScalarValue()) > 0) {
            errorFactory.LBOUND_OF_BETWEEN_BIGGER_THAN_UBOUND.throwAsException();
        }
    }

    public static void validateExpressions(ScanRequest input, LocalDBInputConverter validator) {
        String projectionExpression = input.projectionExpression();
        String filterExpression = input.filterExpression();
        validator.validateMixingOldStyleWithExpressions(null, input.attributesToGet(), null, null, input.scanFilter(), null, input.conditionalOperatorAsString(), null, projectionExpression, null, filterExpression, null);
        validator.validateExpressionAttributeNamesUsedOnlyWithExpressions(projectionExpression, null, filterExpression, null, null, input.expressionAttributeNames());
        validator.validateExpressionAttributeValuesWithFilterExpression(filterExpression, input.expressionAttributeValues());
    }

    public static void validateExpressions(QueryRequest input, LocalDBInputConverter validator) {
        validator.validateMixingOldStyleWithExpressions(null, input.attributesToGet(), null, input.queryFilter(), null, input.keyConditions(), input.conditionalOperatorAsString(), null, input.projectionExpression(), null, input.filterExpression(), input.keyConditionExpression());
        validator.validateExpressionAttributeNamesUsedOnlyWithExpressions(input.projectionExpression(), null, input.filterExpression(), null, input.keyConditionExpression(), input.expressionAttributeNames());
        validator.validateExpressionAttributeValuesWithFilterOrKeyConditionExpression(input.filterExpression(), input.keyConditionExpression(), input.expressionAttributeValues());
    }

    public static void validateExpressions(GetItemRequest input, LocalDBInputConverter validator) {
        String projectionExpression = input.projectionExpression();
        validator.validateMixingOldStyleWithExpressions(null, input.attributesToGet(), null, null, null, null, null, null, projectionExpression, null, null, null);
        validator.validateExpressionAttributeNamesUsedOnlyWithExpressions(projectionExpression, null, null, null, null, LocalDBValidatorUtils.validateExpressionAttributeNames(input.expressionAttributeNames()));
    }

    public static void validateExpressions(PutItemRequest input, LocalDBInputConverter validator) {
        String conditionExpression = input.conditionExpression();
        validator.validateMixingOldStyleWithExpressions(null, null, input.expected(), null, null, null, input.conditionalOperatorAsString(), null, null, conditionExpression, null, null);
        validator.validateExpressionAttributeNamesUsedOnlyWithExpressions(null, conditionExpression, null, null, null, input.expressionAttributeNames());
        validator.validateExpressionAttributeValuesWithConditionExpression(conditionExpression, input.expressionAttributeValues());
    }

    public static void validateExpressions(DeleteItemRequest input, LocalDBInputConverter validator) {
        String conditionExpression = input.conditionExpression();
        validator.validateMixingOldStyleWithExpressions(null, null, input.expected(), null, null, null, input.conditionalOperatorAsString(), null, null, conditionExpression, null, null);
        validator.validateExpressionAttributeNamesUsedOnlyWithExpressions(null, conditionExpression, null, null, null, input.expressionAttributeNames());
        validator.validateExpressionAttributeValuesWithConditionExpression(conditionExpression, input.expressionAttributeValues());
    }

    public static Map<String, String> validateExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        if (expressionAttributeNames != null && expressionAttributeNames.isEmpty()) {
            return null;
        }
        return expressionAttributeNames;
    }

    public static void validateExpressions(UpdateItemRequest input, LocalDBInputConverter validator) {
        String updateExpression = input.updateExpression();
        String conditionExpression = input.conditionExpression();
        validator.validateMixingOldStyleWithExpressions(input.attributeUpdates(), null, input.expected(), null, null, null, input.conditionalOperatorAsString(), updateExpression, null, conditionExpression, null, null);
        validator.validateExpressionAttributeNamesUsedOnlyWithExpressions(null, conditionExpression, null, updateExpression, null, input.expressionAttributeNames());
        validator.validateExpressionAttributeValuesWithUpdateExpressionOrConditionExpression(updateExpression, conditionExpression, input.expressionAttributeValues());
    }

    public static void validateExprAndAttrToGet(BatchGetItemRequest input, LocalDBInputConverter validator) {
        Map requestItems = input.requestItems();
        if (requestItems != null) {
            List attributesToGetAcrossTables = null;
            String projectionExpressionAcrossTables = null;
            for (String tableName : requestItems.keySet()) {
                KeysAndAttributes keysAndAttributes = (KeysAndAttributes)requestItems.get(tableName);
                if (keysAndAttributes == null) continue;
                if (keysAndAttributes.attributesToGet() != null && !keysAndAttributes.attributesToGet().isEmpty()) {
                    attributesToGetAcrossTables = keysAndAttributes.attributesToGet();
                }
                if (keysAndAttributes.projectionExpression() != null && !keysAndAttributes.projectionExpression().isEmpty()) {
                    projectionExpressionAcrossTables = keysAndAttributes.projectionExpression();
                }
                if (attributesToGetAcrossTables != null && projectionExpressionAcrossTables != null) {
                    validator.validateMixingOldStyleWithExpressions(null, attributesToGetAcrossTables, null, null, null, null, null, null, projectionExpressionAcrossTables, null, null, null);
                }
                validator.validateExpressionAttributeNamesUsedOnlyWithExpressions(keysAndAttributes.projectionExpression(), null, null, null, null, keysAndAttributes.expressionAttributeNames());
            }
        }
    }

    public static int validateNestedLevel(int level) {
        if (!LocalDBValidatorUtils.isValidNestedLevel(level)) {
            new AWSExceptionFactory().ITEM_NESTING_LEVELS_LIMIT_EXCEEDED.throwAsException();
        }
        return level;
    }

    private static boolean isValidNestedLevel(int level) {
        return level >= 0 && level < 32;
    }

    public static void validateNoNestedAccessToKeyAttributeInExpression(TableInfo tableInfo, ExpressionsWrapperBase expressionWrapper, ErrorFactory errorFactory) {
        if (expressionWrapper == null) {
            return;
        }
        Set<String> topLevelFieldsWithNestedAccess = expressionWrapper.getTopLevelFieldsWithNestedAccess();
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo.getKeySchema(), topLevelFieldsWithNestedAccess, errorFactory, false);
        if (tableInfo.getLSIIndexes() != null) {
            for (LocalSecondaryIndexDescription localSecondaryIndexDescription : tableInfo.getLSIDescriptions()) {
                LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(localSecondaryIndexDescription.keySchema(), topLevelFieldsWithNestedAccess, errorFactory, true);
            }
        }
        if (tableInfo.hasGSIs()) {
            for (GlobalSecondaryIndexDescription globalSecondaryIndexDescription : tableInfo.getGSIDescriptions()) {
                LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(globalSecondaryIndexDescription.keySchema(), topLevelFieldsWithNestedAccess, errorFactory, true);
            }
        }
    }

    private static void validateNoNestedAccessToKeyAttributeInExpression(List<KeySchemaElement> keySchema, Set<String> topLevelFieldsWithNestedAccess, ErrorFactory errorFactory, boolean isIndexTable) {
        for (KeySchemaElement keySchemaElement : keySchema) {
            String key = keySchemaElement.attributeName();
            if (!topLevelFieldsWithNestedAccess.contains(key)) continue;
            errorFactory.NESTED_ATTRIBUTE_ACCESS_TO_KEY_ATTRIBUTE_IN_EXPRESSION.throwAsException(isIndexTable ? "IndexKey: " + key : "Key: " + key);
        }
    }

    public static String validateReturnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
        if (returnValuesOnConditionCheckFailure == null) {
            return null;
        }
        ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailureValue = ReturnValuesOnConditionCheckFailure.fromValue((String)returnValuesOnConditionCheckFailure);
        if (returnValuesOnConditionCheckFailureValue.equals((Object)ReturnValuesOnConditionCheckFailure.UNKNOWN_TO_SDK_VERSION)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + returnValuesOnConditionCheckFailure + "' at 'returnValuesOnConditionCheckFailure' failed to satisfy constraint: Member must satisfy enum value set: [ALL_OLD, NONE]");
        }
        return returnValuesOnConditionCheckFailure;
    }

    public static Integer validateDescribeStreamLimit(Integer limit2, ErrorFactory errorFactory) {
        if (limit2 == null) {
            return LocalDBUtils.MAX_DESCRIBE_STREAM_LIMIT;
        }
        if (limit2 < 1) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + limit2 + "' at 'limit' failed to satisfy constraint: Member must have value greater than or equal to 1");
        }
        if (limit2 > LocalDBUtils.MAX_DESCRIBE_STREAM_LIMIT) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format("One or more parameter values were invalid: Limit cannot be greater than the maximum: %d", LocalDBUtils.MAX_DESCRIBE_STREAM_LIMIT));
        }
        return limit2;
    }

    public static int validateLimitValueListStreams(Integer limit2, ErrorFactory errorFactory) {
        if (limit2 == null) {
            return 100;
        }
        if (limit2 < 1) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + limit2 + "' at 'limit' failed to satisfy constraint: Member must have value greater than or equal to 1");
        }
        if (limit2 > 100) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "One or more parameter values were invalid: Limit cannot be greater than the maximum allowed size: 100");
        }
        return limit2;
    }

    public static void validateLimitValueExecuteStatement(Integer limit2, ErrorFactory errorFactory) {
        if (limit2 < 1) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + limit2 + "' at 'limit' failed to satisfy constraint: Member must have value greater than or equal to 1");
        }
    }

    public static void validateThatKeyAttributesNotUpdated(TableInfo tableInfo, UpdateExpression updateExpression, ErrorFactory errorFactory) {
        UpdateTreeNode treeRoot;
        if (updateExpression != null && (treeRoot = updateExpression.getTreeRoot()) != null) {
            Set<DocPathElement> topLevelDocPaths = treeRoot.getChildMap().keySet();
            Set<String> attrNames = ExpressionUtils.docPathElementsToAttrNames(topLevelDocPaths);
            for (KeySchemaElement keySchemaElement : tableInfo.getKeySchema()) {
                String key = keySchemaElement.attributeName();
                if (!attrNames.contains(key)) continue;
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), LocalDBClientExceptionMessage.CANNOT_UPDATE_ATTRIBUTE.getMessage() + key + ". " + errorFactory.ATTRIBUTE_PART_OF_KEY.getMessage()));
            }
        }
    }
}

