/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListMilestonesResponse;

public class ListMilestonesIterable
implements SdkIterable<ListMilestonesResponse> {
    private final WellArchitectedClient client;
    private final ListMilestonesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMilestonesIterable(WellArchitectedClient client, ListMilestonesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMilestonesResponseFetcher();
    }

    public Iterator<ListMilestonesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMilestonesResponseFetcher
    implements SyncPageFetcher<ListMilestonesResponse> {
        private ListMilestonesResponseFetcher() {
        }

        public boolean hasNextPage(ListMilestonesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMilestonesResponse nextPage(ListMilestonesResponse previousPage) {
            if (previousPage == null) {
                return ListMilestonesIterable.this.client.listMilestones(ListMilestonesIterable.this.firstRequest);
            }
            return ListMilestonesIterable.this.client.listMilestones((ListMilestonesRequest)((Object)ListMilestonesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

