/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.endpoints.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class RuleArn {
    private final String partition;
    private final String service;
    private final String region;
    private final String accountId;
    private final List<String> resourceId;

    RuleArn(String partition, String service, String region, String accountId, List<String> resourceId) {
        this.partition = partition;
        this.service = service;
        this.region = region;
        this.accountId = accountId;
        this.resourceId = Collections.unmodifiableList(resourceId);
    }

    public static RuleArn parse(String arn) {
        String[] base = arn.split(":", 6);
        if (base.length != 6) {
            return null;
        }
        if (!base[0].equals("arn")) {
            return null;
        }
        if (base[1].isEmpty() || base[2].isEmpty()) {
            return null;
        }
        if (base[5].isEmpty()) {
            return null;
        }
        return new RuleArn(base[1], base[2], base[3], base[4], Arrays.asList(base[5].split("[:/]", -1)));
    }

    public String partition() {
        return this.partition;
    }

    public String service() {
        return this.service;
    }

    public String region() {
        return this.region;
    }

    public String accountId() {
        return this.accountId;
    }

    public List<String> resourceId() {
        return this.resourceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleArn ruleArn = (RuleArn)o;
        return this.partition.equals(ruleArn.partition) && this.service.equals(ruleArn.service) && this.region.equals(ruleArn.region) && this.accountId.equals(ruleArn.accountId) && this.resourceId.equals(ruleArn.resourceId);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.service, this.region, this.accountId, this.resourceId);
    }

    public String toString() {
        return "Arn[partition=" + this.partition + ", service=" + this.service + ", region=" + this.region + ", accountId=" + this.accountId + ", resource=" + this.resourceId + ']';
    }
}

