/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceType {
    APPLICATION_LOAD_BALANCER("APPLICATION_LOAD_BALANCER"),
    API_GATEWAY("API_GATEWAY"),
    APPSYNC("APPSYNC"),
    COGNITO_USER_POOL("COGNITO_USER_POOL"),
    APP_RUNNER_SERVICE("APP_RUNNER_SERVICE"),
    VERIFIED_ACCESS_INSTANCE("VERIFIED_ACCESS_INSTANCE"),
    AMPLIFY("AMPLIFY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceType> VALUE_MAP;
    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        EnumSet<ResourceType> knownValues = EnumSet.allOf(ResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceType.class, ResourceType::toString);
    }
}

