/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenInputItem;
import software.amazon.awssdk.services.verifiedpermissions.model.Decision;
import software.amazon.awssdk.services.verifiedpermissions.model.DeterminingPolicyItem;
import software.amazon.awssdk.services.verifiedpermissions.model.DeterminingPolicyListCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.EvaluationErrorItem;
import software.amazon.awssdk.services.verifiedpermissions.model.EvaluationErrorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchIsAuthorizedWithTokenOutputItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchIsAuthorizedWithTokenOutputItem> {
    private static final SdkField<BatchIsAuthorizedWithTokenInputItem> REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("request").getter(BatchIsAuthorizedWithTokenOutputItem.getter(BatchIsAuthorizedWithTokenOutputItem::request)).setter(BatchIsAuthorizedWithTokenOutputItem.setter(Builder::request)).constructor(BatchIsAuthorizedWithTokenInputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("request").build()}).build();
    private static final SdkField<String> DECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("decision").getter(BatchIsAuthorizedWithTokenOutputItem.getter(BatchIsAuthorizedWithTokenOutputItem::decisionAsString)).setter(BatchIsAuthorizedWithTokenOutputItem.setter(Builder::decision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decision").build()}).build();
    private static final SdkField<List<DeterminingPolicyItem>> DETERMINING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("determiningPolicies").getter(BatchIsAuthorizedWithTokenOutputItem.getter(BatchIsAuthorizedWithTokenOutputItem::determiningPolicies)).setter(BatchIsAuthorizedWithTokenOutputItem.setter(Builder::determiningPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("determiningPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeterminingPolicyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EvaluationErrorItem>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchIsAuthorizedWithTokenOutputItem.getter(BatchIsAuthorizedWithTokenOutputItem::errors)).setter(BatchIsAuthorizedWithTokenOutputItem.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationErrorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_FIELD, DECISION_FIELD, DETERMINING_POLICIES_FIELD, ERRORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final BatchIsAuthorizedWithTokenInputItem request;
    private final String decision;
    private final List<DeterminingPolicyItem> determiningPolicies;
    private final List<EvaluationErrorItem> errors;

    private BatchIsAuthorizedWithTokenOutputItem(BuilderImpl builder) {
        this.request = builder.request;
        this.decision = builder.decision;
        this.determiningPolicies = builder.determiningPolicies;
        this.errors = builder.errors;
    }

    public final BatchIsAuthorizedWithTokenInputItem request() {
        return this.request;
    }

    public final Decision decision() {
        return Decision.fromValue(this.decision);
    }

    public final String decisionAsString() {
        return this.decision;
    }

    public final boolean hasDeterminingPolicies() {
        return this.determiningPolicies != null && !(this.determiningPolicies instanceof SdkAutoConstructList);
    }

    public final List<DeterminingPolicyItem> determiningPolicies() {
        return this.determiningPolicies;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<EvaluationErrorItem> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.request());
        hashCode = 31 * hashCode + Objects.hashCode(this.decisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeterminingPolicies() ? this.determiningPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchIsAuthorizedWithTokenOutputItem)) {
            return false;
        }
        BatchIsAuthorizedWithTokenOutputItem other = (BatchIsAuthorizedWithTokenOutputItem)obj;
        return Objects.equals(this.request(), other.request()) && Objects.equals(this.decisionAsString(), other.decisionAsString()) && this.hasDeterminingPolicies() == other.hasDeterminingPolicies() && Objects.equals(this.determiningPolicies(), other.determiningPolicies()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchIsAuthorizedWithTokenOutputItem").add("Request", (Object)this.request()).add("Decision", (Object)this.decisionAsString()).add("DeterminingPolicies", this.hasDeterminingPolicies() ? this.determiningPolicies() : null).add("Errors", (Object)(this.errors() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "request": {
                return Optional.ofNullable(clazz.cast(this.request()));
            }
            case "decision": {
                return Optional.ofNullable(clazz.cast(this.decisionAsString()));
            }
            case "determiningPolicies": {
                return Optional.ofNullable(clazz.cast(this.determiningPolicies()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchIsAuthorizedWithTokenOutputItem, T> g) {
        return obj -> g.apply((BatchIsAuthorizedWithTokenOutputItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BatchIsAuthorizedWithTokenInputItem request;
        private String decision;
        private List<DeterminingPolicyItem> determiningPolicies = DefaultSdkAutoConstructList.getInstance();
        private List<EvaluationErrorItem> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchIsAuthorizedWithTokenOutputItem model) {
            this.request(model.request);
            this.decision(model.decision);
            this.determiningPolicies(model.determiningPolicies);
            this.errors(model.errors);
        }

        public final BatchIsAuthorizedWithTokenInputItem.Builder getRequest() {
            return this.request != null ? this.request.toBuilder() : null;
        }

        public final void setRequest(BatchIsAuthorizedWithTokenInputItem.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        public final Builder request(BatchIsAuthorizedWithTokenInputItem request) {
            this.request = request;
            return this;
        }

        public final String getDecision() {
            return this.decision;
        }

        public final void setDecision(String decision) {
            this.decision = decision;
        }

        @Override
        public final Builder decision(String decision) {
            this.decision = decision;
            return this;
        }

        @Override
        public final Builder decision(Decision decision) {
            this.decision(decision == null ? null : decision.toString());
            return this;
        }

        public final List<DeterminingPolicyItem.Builder> getDeterminingPolicies() {
            List<DeterminingPolicyItem.Builder> result = DeterminingPolicyListCopier.copyToBuilder(this.determiningPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeterminingPolicies(Collection<DeterminingPolicyItem.BuilderImpl> determiningPolicies) {
            this.determiningPolicies = DeterminingPolicyListCopier.copyFromBuilder(determiningPolicies);
        }

        @Override
        public final Builder determiningPolicies(Collection<DeterminingPolicyItem> determiningPolicies) {
            this.determiningPolicies = DeterminingPolicyListCopier.copy(determiningPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder determiningPolicies(DeterminingPolicyItem ... determiningPolicies) {
            this.determiningPolicies(Arrays.asList(determiningPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder determiningPolicies(Consumer<DeterminingPolicyItem.Builder> ... determiningPolicies) {
            this.determiningPolicies(Stream.of(determiningPolicies).map(c -> (DeterminingPolicyItem)((DeterminingPolicyItem.Builder)DeterminingPolicyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EvaluationErrorItem.Builder> getErrors() {
            List<EvaluationErrorItem.Builder> result = EvaluationErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<EvaluationErrorItem.BuilderImpl> errors) {
            this.errors = EvaluationErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<EvaluationErrorItem> errors) {
            this.errors = EvaluationErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(EvaluationErrorItem ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<EvaluationErrorItem.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (EvaluationErrorItem)((EvaluationErrorItem.Builder)EvaluationErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BatchIsAuthorizedWithTokenOutputItem build() {
            return new BatchIsAuthorizedWithTokenOutputItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchIsAuthorizedWithTokenOutputItem> {
        public Builder request(BatchIsAuthorizedWithTokenInputItem var1);

        default public Builder request(Consumer<BatchIsAuthorizedWithTokenInputItem.Builder> request) {
            return this.request((BatchIsAuthorizedWithTokenInputItem)((BatchIsAuthorizedWithTokenInputItem.Builder)BatchIsAuthorizedWithTokenInputItem.builder().applyMutation(request)).build());
        }

        public Builder decision(String var1);

        public Builder decision(Decision var1);

        public Builder determiningPolicies(Collection<DeterminingPolicyItem> var1);

        public Builder determiningPolicies(DeterminingPolicyItem ... var1);

        public Builder determiningPolicies(Consumer<DeterminingPolicyItem.Builder> ... var1);

        public Builder errors(Collection<EvaluationErrorItem> var1);

        public Builder errors(EvaluationErrorItem ... var1);

        public Builder errors(Consumer<EvaluationErrorItem.Builder> ... var1);
    }
}

