/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClient;
import software.amazon.awssdk.services.transcribe.internal.UserAgentUtils;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesRequest;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsCategoriesResponse;

public class ListCallAnalyticsCategoriesPublisher
implements SdkPublisher<ListCallAnalyticsCategoriesResponse> {
    private final TranscribeAsyncClient client;
    private final ListCallAnalyticsCategoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCallAnalyticsCategoriesPublisher(TranscribeAsyncClient client, ListCallAnalyticsCategoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCallAnalyticsCategoriesPublisher(TranscribeAsyncClient client, ListCallAnalyticsCategoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCallAnalyticsCategoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCallAnalyticsCategoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCallAnalyticsCategoriesResponseFetcher
    implements AsyncPageFetcher<ListCallAnalyticsCategoriesResponse> {
        private ListCallAnalyticsCategoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListCallAnalyticsCategoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCallAnalyticsCategoriesResponse> nextPage(ListCallAnalyticsCategoriesResponse previousPage) {
            if (previousPage == null) {
                return ListCallAnalyticsCategoriesPublisher.this.client.listCallAnalyticsCategories(ListCallAnalyticsCategoriesPublisher.this.firstRequest);
            }
            return ListCallAnalyticsCategoriesPublisher.this.client.listCallAnalyticsCategories((ListCallAnalyticsCategoriesRequest)((Object)ListCallAnalyticsCategoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

