/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClient;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse;

public class ListCallAnalyticsJobsPublisher
implements SdkPublisher<ListCallAnalyticsJobsResponse> {
    private final TranscribeAsyncClient client;
    private final ListCallAnalyticsJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCallAnalyticsJobsPublisher(TranscribeAsyncClient client, ListCallAnalyticsJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCallAnalyticsJobsPublisher(TranscribeAsyncClient client, ListCallAnalyticsJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCallAnalyticsJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCallAnalyticsJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCallAnalyticsJobsResponseFetcher
    implements AsyncPageFetcher<ListCallAnalyticsJobsResponse> {
        private ListCallAnalyticsJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCallAnalyticsJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCallAnalyticsJobsResponse> nextPage(ListCallAnalyticsJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCallAnalyticsJobsPublisher.this.client.listCallAnalyticsJobs(ListCallAnalyticsJobsPublisher.this.firstRequest);
            }
            return ListCallAnalyticsJobsPublisher.this.client.listCallAnalyticsJobs((ListCallAnalyticsJobsRequest)((Object)ListCallAnalyticsJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

