/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.services.swf.model.WorkflowExecution;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkflowExecutionRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, DescribeWorkflowExecutionRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(DescribeWorkflowExecutionRequest.getter(DescribeWorkflowExecutionRequest::domain)).setter(DescribeWorkflowExecutionRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<WorkflowExecution> EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("execution").getter(DescribeWorkflowExecutionRequest.getter(DescribeWorkflowExecutionRequest::execution)).setter(DescribeWorkflowExecutionRequest.setter(Builder::execution)).constructor(WorkflowExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("execution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, EXECUTION_FIELD));
    private final String domain;
    private final WorkflowExecution execution;

    private DescribeWorkflowExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.execution = builder.execution;
    }

    public final String domain() {
        return this.domain;
    }

    public final WorkflowExecution execution() {
        return this.execution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.execution());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkflowExecutionRequest)) {
            return false;
        }
        DescribeWorkflowExecutionRequest other = (DescribeWorkflowExecutionRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.execution(), other.execution());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkflowExecutionRequest").add("Domain", (Object)this.domain()).add("Execution", (Object)this.execution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "execution": {
                return Optional.ofNullable(clazz.cast(this.execution()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkflowExecutionRequest, T> g) {
        return obj -> g.apply((DescribeWorkflowExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private WorkflowExecution execution;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkflowExecutionRequest model) {
            super(model);
            this.domain(model.domain);
            this.execution(model.execution);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final WorkflowExecution.Builder getExecution() {
            return this.execution != null ? this.execution.toBuilder() : null;
        }

        public final void setExecution(WorkflowExecution.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        @Override
        public final Builder execution(WorkflowExecution execution) {
            this.execution = execution;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkflowExecutionRequest build() {
            return new DescribeWorkflowExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkflowExecutionRequest> {
        public Builder domain(String var1);

        public Builder execution(WorkflowExecution var1);

        default public Builder execution(Consumer<WorkflowExecution.Builder> execution) {
            return this.execution((WorkflowExecution)((WorkflowExecution.Builder)WorkflowExecution.builder().applyMutation(execution)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

