/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configurations for sending notifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationConfig.Builder, NotificationConfig> {
    private static final SdkField<String> NOTIFICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationArn").getter(getter(NotificationConfig::notificationArn))
            .setter(setter(Builder::notificationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArn").build()).build();

    private static final SdkField<List<String>> NOTIFICATION_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotificationEvents")
            .getter(getter(NotificationConfig::notificationEventsAsStrings))
            .setter(setter(Builder::notificationEventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationType").getter(getter(NotificationConfig::notificationTypeAsString))
            .setter(setter(Builder::notificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_ARN_FIELD,
            NOTIFICATION_EVENTS_FIELD, NOTIFICATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String notificationArn;

    private final List<String> notificationEvents;

    private final String notificationType;

    private NotificationConfig(BuilderImpl builder) {
        this.notificationArn = builder.notificationArn;
        this.notificationEvents = builder.notificationEvents;
        this.notificationType = builder.notificationType;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic. Run Command pushes
     * notifications about command status changes to this topic.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic. Run Command
     *         pushes notifications about command status changes to this topic.
     */
    public final String notificationArn() {
        return notificationArn;
    }

    /**
     * <p>
     * The different events for which you can receive notifications. To learn more about these events, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">Monitoring
     * Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web Services Systems Manager
     * User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationEvents} method.
     * </p>
     * 
     * @return The different events for which you can receive notifications. To learn more about these events, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">
     *         Monitoring Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web
     *         Services Systems Manager User Guide</i>.
     */
    public final List<NotificationEvent> notificationEvents() {
        return NotificationEventListCopier.copyStringToEnum(notificationEvents);
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationEvents property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotificationEvents() {
        return notificationEvents != null && !(notificationEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The different events for which you can receive notifications. To learn more about these events, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">Monitoring
     * Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web Services Systems Manager
     * User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationEvents} method.
     * </p>
     * 
     * @return The different events for which you can receive notifications. To learn more about these events, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">
     *         Monitoring Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web
     *         Services Systems Manager User Guide</i>.
     */
    public final List<String> notificationEventsAsStrings() {
        return notificationEvents;
    }

    /**
     * <p>
     * The type of notification.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Command</code>: Receive notification when the status of a command changes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Invocation</code>: For commands sent to multiple managed nodes, receive notification on a per-node basis
     * when the status of a command changes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeAsString}.
     * </p>
     * 
     * @return The type of notification.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Command</code>: Receive notification when the status of a command changes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Invocation</code>: For commands sent to multiple managed nodes, receive notification on a per-node
     *         basis when the status of a command changes.
     *         </p>
     *         </li>
     * @see NotificationType
     */
    public final NotificationType notificationType() {
        return NotificationType.fromValue(notificationType);
    }

    /**
     * <p>
     * The type of notification.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Command</code>: Receive notification when the status of a command changes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Invocation</code>: For commands sent to multiple managed nodes, receive notification on a per-node basis
     * when the status of a command changes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeAsString}.
     * </p>
     * 
     * @return The type of notification.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Command</code>: Receive notification when the status of a command changes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Invocation</code>: For commands sent to multiple managed nodes, receive notification on a per-node
     *         basis when the status of a command changes.
     *         </p>
     *         </li>
     * @see NotificationType
     */
    public final String notificationTypeAsString() {
        return notificationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationEvents() ? notificationEventsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(notificationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfig)) {
            return false;
        }
        NotificationConfig other = (NotificationConfig) obj;
        return Objects.equals(notificationArn(), other.notificationArn())
                && hasNotificationEvents() == other.hasNotificationEvents()
                && Objects.equals(notificationEventsAsStrings(), other.notificationEventsAsStrings())
                && Objects.equals(notificationTypeAsString(), other.notificationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationConfig").add("NotificationArn", notificationArn())
                .add("NotificationEvents", hasNotificationEvents() ? notificationEventsAsStrings() : null)
                .add("NotificationType", notificationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotificationArn":
            return Optional.ofNullable(clazz.cast(notificationArn()));
        case "NotificationEvents":
            return Optional.ofNullable(clazz.cast(notificationEventsAsStrings()));
        case "NotificationType":
            return Optional.ofNullable(clazz.cast(notificationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NotificationArn", NOTIFICATION_ARN_FIELD);
        map.put("NotificationEvents", NOTIFICATION_EVENTS_FIELD);
        map.put("NotificationType", NOTIFICATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationConfig, T> g) {
        return obj -> g.apply((NotificationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationConfig> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic. Run Command
         * pushes notifications about command status changes to this topic.
         * </p>
         * 
         * @param notificationArn
         *        An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic. Run
         *        Command pushes notifications about command status changes to this topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationArn(String notificationArn);

        /**
         * <p>
         * The different events for which you can receive notifications. To learn more about these events, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html"
         * >Monitoring Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web Services
         * Systems Manager User Guide</i>.
         * </p>
         * 
         * @param notificationEvents
         *        The different events for which you can receive notifications. To learn more about these events, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">
         *        Monitoring Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web
         *        Services Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEventsWithStrings(Collection<String> notificationEvents);

        /**
         * <p>
         * The different events for which you can receive notifications. To learn more about these events, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html"
         * >Monitoring Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web Services
         * Systems Manager User Guide</i>.
         * </p>
         * 
         * @param notificationEvents
         *        The different events for which you can receive notifications. To learn more about these events, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">
         *        Monitoring Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web
         *        Services Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEventsWithStrings(String... notificationEvents);

        /**
         * <p>
         * The different events for which you can receive notifications. To learn more about these events, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html"
         * >Monitoring Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web Services
         * Systems Manager User Guide</i>.
         * </p>
         * 
         * @param notificationEvents
         *        The different events for which you can receive notifications. To learn more about these events, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">
         *        Monitoring Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web
         *        Services Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEvents(Collection<NotificationEvent> notificationEvents);

        /**
         * <p>
         * The different events for which you can receive notifications. To learn more about these events, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html"
         * >Monitoring Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web Services
         * Systems Manager User Guide</i>.
         * </p>
         * 
         * @param notificationEvents
         *        The different events for which you can receive notifications. To learn more about these events, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">
         *        Monitoring Systems Manager status changes using Amazon SNS notifications</a> in the <i>Amazon Web
         *        Services Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEvents(NotificationEvent... notificationEvents);

        /**
         * <p>
         * The type of notification.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Command</code>: Receive notification when the status of a command changes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Invocation</code>: For commands sent to multiple managed nodes, receive notification on a per-node
         * basis when the status of a command changes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param notificationType
         *        The type of notification.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Command</code>: Receive notification when the status of a command changes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Invocation</code>: For commands sent to multiple managed nodes, receive notification on a
         *        per-node basis when the status of a command changes.
         *        </p>
         *        </li>
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(String notificationType);

        /**
         * <p>
         * The type of notification.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Command</code>: Receive notification when the status of a command changes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Invocation</code>: For commands sent to multiple managed nodes, receive notification on a per-node
         * basis when the status of a command changes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param notificationType
         *        The type of notification.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Command</code>: Receive notification when the status of a command changes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Invocation</code>: For commands sent to multiple managed nodes, receive notification on a
         *        per-node basis when the status of a command changes.
         *        </p>
         *        </li>
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(NotificationType notificationType);
    }

    static final class BuilderImpl implements Builder {
        private String notificationArn;

        private List<String> notificationEvents = DefaultSdkAutoConstructList.getInstance();

        private String notificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfig model) {
            notificationArn(model.notificationArn);
            notificationEventsWithStrings(model.notificationEvents);
            notificationType(model.notificationType);
        }

        public final String getNotificationArn() {
            return notificationArn;
        }

        public final void setNotificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
        }

        @Override
        public final Builder notificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
            return this;
        }

        public final Collection<String> getNotificationEvents() {
            if (notificationEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return notificationEvents;
        }

        public final void setNotificationEvents(Collection<String> notificationEvents) {
            this.notificationEvents = NotificationEventListCopier.copy(notificationEvents);
        }

        @Override
        public final Builder notificationEventsWithStrings(Collection<String> notificationEvents) {
            this.notificationEvents = NotificationEventListCopier.copy(notificationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationEventsWithStrings(String... notificationEvents) {
            notificationEventsWithStrings(Arrays.asList(notificationEvents));
            return this;
        }

        @Override
        public final Builder notificationEvents(Collection<NotificationEvent> notificationEvents) {
            this.notificationEvents = NotificationEventListCopier.copyEnumToString(notificationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationEvents(NotificationEvent... notificationEvents) {
            notificationEvents(Arrays.asList(notificationEvents));
            return this;
        }

        public final String getNotificationType() {
            return notificationType;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType == null ? null : notificationType.toString());
            return this;
        }

        @Override
        public NotificationConfig build() {
            return new NotificationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
