/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOpsItemEventsResponse extends SsmResponse implements
        ToCopyableBuilder<ListOpsItemEventsResponse.Builder, ListOpsItemEventsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOpsItemEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<OpsItemEventSummary>> SUMMARIES_FIELD = SdkField
            .<List<OpsItemEventSummary>> builder(MarshallingType.LIST)
            .memberName("Summaries")
            .getter(getter(ListOpsItemEventsResponse::summaries))
            .setter(setter(Builder::summaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsItemEventSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsItemEventSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<OpsItemEventSummary> summaries;

    private ListOpsItemEventsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.summaries = builder.summaries;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Summaries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSummaries() {
        return summaries != null && !(summaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event information for the specified OpsItems.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSummaries} method.
     * </p>
     * 
     * @return A list of event information for the specified OpsItems.
     */
    public final List<OpsItemEventSummary> summaries() {
        return summaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSummaries() ? summaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpsItemEventsResponse)) {
            return false;
        }
        ListOpsItemEventsResponse other = (ListOpsItemEventsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSummaries() == other.hasSummaries()
                && Objects.equals(summaries(), other.summaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOpsItemEventsResponse").add("NextToken", nextToken())
                .add("Summaries", hasSummaries() ? summaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Summaries":
            return Optional.ofNullable(clazz.cast(summaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Summaries", SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOpsItemEventsResponse, T> g) {
        return obj -> g.apply((ListOpsItemEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOpsItemEventsResponse> {
        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of event information for the specified OpsItems.
         * </p>
         * 
         * @param summaries
         *        A list of event information for the specified OpsItems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Collection<OpsItemEventSummary> summaries);

        /**
         * <p>
         * A list of event information for the specified OpsItems.
         * </p>
         * 
         * @param summaries
         *        A list of event information for the specified OpsItems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(OpsItemEventSummary... summaries);

        /**
         * <p>
         * A list of event information for the specified OpsItems.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.OpsItemEventSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssm.model.OpsItemEventSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.OpsItemEventSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #summaries(List<OpsItemEventSummary>)}.
         * 
         * @param summaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.OpsItemEventSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaries(java.util.Collection<OpsItemEventSummary>)
         */
        Builder summaries(Consumer<OpsItemEventSummary.Builder>... summaries);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<OpsItemEventSummary> summaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpsItemEventsResponse model) {
            super(model);
            nextToken(model.nextToken);
            summaries(model.summaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<OpsItemEventSummary.Builder> getSummaries() {
            List<OpsItemEventSummary.Builder> result = OpsItemEventSummariesCopier.copyToBuilder(this.summaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaries(Collection<OpsItemEventSummary.BuilderImpl> summaries) {
            this.summaries = OpsItemEventSummariesCopier.copyFromBuilder(summaries);
        }

        @Override
        public final Builder summaries(Collection<OpsItemEventSummary> summaries) {
            this.summaries = OpsItemEventSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(OpsItemEventSummary... summaries) {
            summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<OpsItemEventSummary.Builder>... summaries) {
            summaries(Stream.of(summaries).map(c -> OpsItemEventSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListOpsItemEventsResponse build() {
            return new ListOpsItemEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
