/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the inventory type and attribute for the aggregation execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InventoryAggregator implements SdkPojo, Serializable,
        ToCopyableBuilder<InventoryAggregator.Builder, InventoryAggregator> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(InventoryAggregator::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<List<InventoryAggregator>> AGGREGATORS_FIELD = SdkField
            .<List<InventoryAggregator>> builder(MarshallingType.LIST)
            .memberName("Aggregators")
            .getter(getter(InventoryAggregator::aggregators))
            .setter(setter(Builder::aggregators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InventoryAggregator> builder(MarshallingType.SDK_POJO)
                                            .constructor(InventoryAggregator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InventoryGroup>> GROUPS_FIELD = SdkField
            .<List<InventoryGroup>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(InventoryAggregator::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InventoryGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(InventoryGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD,
            AGGREGATORS_FIELD, GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final List<InventoryAggregator> aggregators;

    private final List<InventoryGroup> groups;

    private InventoryAggregator(BuilderImpl builder) {
        this.expression = builder.expression;
        this.aggregators = builder.aggregators;
        this.groups = builder.groups;
    }

    /**
     * <p>
     * The inventory type and attribute name for aggregation.
     * </p>
     * 
     * @return The inventory type and attribute name for aggregation.
     */
    public final String expression() {
        return expression;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aggregators property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregators() {
        return aggregators != null && !(aggregators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Nested aggregators to further refine aggregation for an inventory type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregators} method.
     * </p>
     * 
     * @return Nested aggregators to further refine aggregation for an inventory type.
     */
    public final List<InventoryAggregator> aggregators() {
        return aggregators;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A user-defined set of one or more filters on which to aggregate inventory data. Groups return a count of
     * resources that match and don't match the specified criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return A user-defined set of one or more filters on which to aggregate inventory data. Groups return a count of
     *         resources that match and don't match the specified criteria.
     */
    public final List<InventoryGroup> groups() {
        return groups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregators() ? aggregators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryAggregator)) {
            return false;
        }
        InventoryAggregator other = (InventoryAggregator) obj;
        return Objects.equals(expression(), other.expression()) && hasAggregators() == other.hasAggregators()
                && Objects.equals(aggregators(), other.aggregators()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InventoryAggregator").add("Expression", expression())
                .add("Aggregators", hasAggregators() ? aggregators() : null).add("Groups", hasGroups() ? groups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "Aggregators":
            return Optional.ofNullable(clazz.cast(aggregators()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Expression", EXPRESSION_FIELD);
        map.put("Aggregators", AGGREGATORS_FIELD);
        map.put("Groups", GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InventoryAggregator, T> g) {
        return obj -> g.apply((InventoryAggregator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InventoryAggregator> {
        /**
         * <p>
         * The inventory type and attribute name for aggregation.
         * </p>
         * 
         * @param expression
         *        The inventory type and attribute name for aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * Nested aggregators to further refine aggregation for an inventory type.
         * </p>
         * 
         * @param aggregators
         *        Nested aggregators to further refine aggregation for an inventory type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(Collection<InventoryAggregator> aggregators);

        /**
         * <p>
         * Nested aggregators to further refine aggregation for an inventory type.
         * </p>
         * 
         * @param aggregators
         *        Nested aggregators to further refine aggregation for an inventory type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(InventoryAggregator... aggregators);

        /**
         * <p>
         * Nested aggregators to further refine aggregation for an inventory type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.InventoryAggregator.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssm.model.InventoryAggregator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.InventoryAggregator.Builder#build()} is called immediately
         * and its result is passed to {@link #aggregators(List<InventoryAggregator>)}.
         * 
         * @param aggregators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.InventoryAggregator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregators(java.util.Collection<InventoryAggregator>)
         */
        Builder aggregators(Consumer<Builder>... aggregators);

        /**
         * <p>
         * A user-defined set of one or more filters on which to aggregate inventory data. Groups return a count of
         * resources that match and don't match the specified criteria.
         * </p>
         * 
         * @param groups
         *        A user-defined set of one or more filters on which to aggregate inventory data. Groups return a count
         *        of resources that match and don't match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<InventoryGroup> groups);

        /**
         * <p>
         * A user-defined set of one or more filters on which to aggregate inventory data. Groups return a count of
         * resources that match and don't match the specified criteria.
         * </p>
         * 
         * @param groups
         *        A user-defined set of one or more filters on which to aggregate inventory data. Groups return a count
         *        of resources that match and don't match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(InventoryGroup... groups);

        /**
         * <p>
         * A user-defined set of one or more filters on which to aggregate inventory data. Groups return a count of
         * resources that match and don't match the specified criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.InventoryGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssm.model.InventoryGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.InventoryGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #groups(List<InventoryGroup>)}.
         * 
         * @param groups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.InventoryGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(java.util.Collection<InventoryGroup>)
         */
        Builder groups(Consumer<InventoryGroup.Builder>... groups);
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private List<InventoryAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();

        private List<InventoryGroup> groups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryAggregator model) {
            expression(model.expression);
            aggregators(model.aggregators);
            groups(model.groups);
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final List<Builder> getAggregators() {
            List<Builder> result = InventoryAggregatorListCopier.copyToBuilder(this.aggregators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregators(Collection<BuilderImpl> aggregators) {
            this.aggregators = InventoryAggregatorListCopier.copyFromBuilder(aggregators);
        }

        @Override
        public final Builder aggregators(Collection<InventoryAggregator> aggregators) {
            this.aggregators = InventoryAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(InventoryAggregator... aggregators) {
            aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(Consumer<Builder>... aggregators) {
            aggregators(Stream.of(aggregators).map(c -> InventoryAggregator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<InventoryGroup.Builder> getGroups() {
            List<InventoryGroup.Builder> result = InventoryGroupListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<InventoryGroup.BuilderImpl> groups) {
            this.groups = InventoryGroupListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<InventoryGroup> groups) {
            this.groups = InventoryGroupListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(InventoryGroup... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<InventoryGroup.Builder>... groups) {
            groups(Stream.of(groups).map(c -> InventoryGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InventoryAggregator build() {
            return new InventoryAggregator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
