/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.OpsAggregatorListCopier;
import software.amazon.awssdk.services.ssm.model.OpsAggregatorValueMapCopier;
import software.amazon.awssdk.services.ssm.model.OpsFilter;
import software.amazon.awssdk.services.ssm.model.OpsFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpsAggregator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpsAggregator> {
    private static final SdkField<String> AGGREGATOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregatorType").getter(OpsAggregator.getter(OpsAggregator::aggregatorType)).setter(OpsAggregator.setter(Builder::aggregatorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorType").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(OpsAggregator.getter(OpsAggregator::typeName)).setter(OpsAggregator.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(OpsAggregator.getter(OpsAggregator::attributeName)).setter(OpsAggregator.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<Map<String, String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Values").getter(OpsAggregator.getter(OpsAggregator::values)).setter(OpsAggregator.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<OpsFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(OpsAggregator.getter(OpsAggregator::filters)).setter(OpsAggregator.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OpsAggregator>> AGGREGATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aggregators").getter(OpsAggregator.getter(OpsAggregator::aggregators)).setter(OpsAggregator.setter(Builder::aggregators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsAggregator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATOR_TYPE_FIELD, TYPE_NAME_FIELD, ATTRIBUTE_NAME_FIELD, VALUES_FIELD, FILTERS_FIELD, AGGREGATORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpsAggregator.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String aggregatorType;
    private final String typeName;
    private final String attributeName;
    private final Map<String, String> values;
    private final List<OpsFilter> filters;
    private final List<OpsAggregator> aggregators;

    private OpsAggregator(BuilderImpl builder) {
        this.aggregatorType = builder.aggregatorType;
        this.typeName = builder.typeName;
        this.attributeName = builder.attributeName;
        this.values = builder.values;
        this.filters = builder.filters;
        this.aggregators = builder.aggregators;
    }

    public final String aggregatorType() {
        return this.aggregatorType;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> values() {
        return this.values;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<OpsFilter> filters() {
        return this.filters;
    }

    public final boolean hasAggregators() {
        return this.aggregators != null && !(this.aggregators instanceof SdkAutoConstructList);
    }

    public final List<OpsAggregator> aggregators() {
        return this.aggregators;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatorType());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregators() ? this.aggregators() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsAggregator)) {
            return false;
        }
        OpsAggregator other = (OpsAggregator)obj;
        return Objects.equals(this.aggregatorType(), other.aggregatorType()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.attributeName(), other.attributeName()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasAggregators() == other.hasAggregators() && Objects.equals(this.aggregators(), other.aggregators());
    }

    public final String toString() {
        return ToString.builder((String)"OpsAggregator").add("AggregatorType", (Object)this.aggregatorType()).add("TypeName", (Object)this.typeName()).add("AttributeName", (Object)this.attributeName()).add("Values", this.hasValues() ? this.values() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("Aggregators", this.hasAggregators() ? this.aggregators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregatorType": {
                return Optional.ofNullable(clazz.cast(this.aggregatorType()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Aggregators": {
                return Optional.ofNullable(clazz.cast(this.aggregators()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AggregatorType", AGGREGATOR_TYPE_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("Aggregators", AGGREGATORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpsAggregator, T> g) {
        return obj -> g.apply((OpsAggregator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aggregatorType;
        private String typeName;
        private String attributeName;
        private Map<String, String> values = DefaultSdkAutoConstructMap.getInstance();
        private List<OpsFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<OpsAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpsAggregator model) {
            this.aggregatorType(model.aggregatorType);
            this.typeName(model.typeName);
            this.attributeName(model.attributeName);
            this.values(model.values);
            this.filters(model.filters);
            this.aggregators(model.aggregators);
        }

        public final String getAggregatorType() {
            return this.aggregatorType;
        }

        public final void setAggregatorType(String aggregatorType) {
            this.aggregatorType = aggregatorType;
        }

        @Override
        public final Builder aggregatorType(String aggregatorType) {
            this.aggregatorType = aggregatorType;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final Map<String, String> getValues() {
            if (this.values instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Map<String, String> values) {
            this.values = OpsAggregatorValueMapCopier.copy(values);
        }

        @Override
        public final Builder values(Map<String, String> values) {
            this.values = OpsAggregatorValueMapCopier.copy(values);
            return this;
        }

        public final List<OpsFilter.Builder> getFilters() {
            List<OpsFilter.Builder> result = OpsFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<OpsFilter.BuilderImpl> filters) {
            this.filters = OpsFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<OpsFilter> filters) {
            this.filters = OpsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(OpsFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<OpsFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (OpsFilter)((OpsFilter.Builder)OpsFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAggregators() {
            List<Builder> result = OpsAggregatorListCopier.copyToBuilder(this.aggregators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregators(Collection<BuilderImpl> aggregators) {
            this.aggregators = OpsAggregatorListCopier.copyFromBuilder(aggregators);
        }

        @Override
        public final Builder aggregators(Collection<OpsAggregator> aggregators) {
            this.aggregators = OpsAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(OpsAggregator ... aggregators) {
            this.aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(Consumer<Builder> ... aggregators) {
            this.aggregators(Stream.of(aggregators).map(c -> (OpsAggregator)((Builder)OpsAggregator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OpsAggregator build() {
            return new OpsAggregator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpsAggregator> {
        public Builder aggregatorType(String var1);

        public Builder typeName(String var1);

        public Builder attributeName(String var1);

        public Builder values(Map<String, String> var1);

        public Builder filters(Collection<OpsFilter> var1);

        public Builder filters(OpsFilter ... var1);

        public Builder filters(Consumer<OpsFilter.Builder> ... var1);

        public Builder aggregators(Collection<OpsAggregator> var1);

        public Builder aggregators(OpsAggregator ... var1);

        public Builder aggregators(Consumer<Builder> ... var1);
    }
}

