/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutomationExecutionFilterKey {
    DOCUMENT_NAME_PREFIX("DocumentNamePrefix"),
    EXECUTION_STATUS("ExecutionStatus"),
    EXECUTION_ID("ExecutionId"),
    PARENT_EXECUTION_ID("ParentExecutionId"),
    CURRENT_ACTION("CurrentAction"),
    START_TIME_BEFORE("StartTimeBefore"),
    START_TIME_AFTER("StartTimeAfter"),
    AUTOMATION_TYPE("AutomationType"),
    TAG_KEY("TagKey"),
    TARGET_RESOURCE_GROUP("TargetResourceGroup"),
    AUTOMATION_SUBTYPE("AutomationSubtype"),
    OPS_ITEM_ID("OpsItemId"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutomationExecutionFilterKey> VALUE_MAP;
    private final String value;

    private AutomationExecutionFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutomationExecutionFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutomationExecutionFilterKey> knownValues() {
        EnumSet<AutomationExecutionFilterKey> knownValues = EnumSet.allOf(AutomationExecutionFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutomationExecutionFilterKey.class, AutomationExecutionFilterKey::toString);
    }
}

