/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the optional inputs that can be specified for an automation execution preview.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationExecutionInputs implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationExecutionInputs.Builder, AutomationExecutionInputs> {
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(AutomationExecutionInputs::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> TARGET_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetParameterName").getter(getter(AutomationExecutionInputs::targetParameterName))
            .setter(setter(Builder::targetParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameterName").build())
            .build();

    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(AutomationExecutionInputs::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField
            .<List<Map<String, List<String>>>> builder(MarshallingType.LIST)
            .memberName("TargetMaps")
            .getter(getter(AutomationExecutionInputs::targetMaps))
            .setter(setter(Builder::targetMaps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, List<String>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField
            .<List<TargetLocation>> builder(MarshallingType.LIST)
            .memberName("TargetLocations")
            .getter(getter(AutomationExecutionInputs::targetLocations))
            .setter(setter(Builder::targetLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_LOCATIONS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetLocationsURL").getter(getter(AutomationExecutionInputs::targetLocationsURL))
            .setter(setter(Builder::targetLocationsURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocationsURL").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETERS_FIELD,
            TARGET_PARAMETER_NAME_FIELD, TARGETS_FIELD, TARGET_MAPS_FIELD, TARGET_LOCATIONS_FIELD, TARGET_LOCATIONS_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, List<String>> parameters;

    private final String targetParameterName;

    private final List<Target> targets;

    private final List<Map<String, List<String>>> targetMaps;

    private final List<TargetLocation> targetLocations;

    private final String targetLocationsURL;

    private AutomationExecutionInputs(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.targetParameterName = builder.targetParameterName;
        this.targets = builder.targets;
        this.targetMaps = builder.targetMaps;
        this.targetLocations = builder.targetLocations;
        this.targetLocationsURL = builder.targetLocationsURL;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Information about parameters that can be specified for the preview operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Information about parameters that can be specified for the preview operation.
     */
    public final Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The name of the parameter used as the target resource for the rate-controlled execution. Required if you specify
     * targets.
     * </p>
     * 
     * @return The name of the parameter used as the target resource for the rate-controlled execution. Required if you
     *         specify targets.
     */
    public final String targetParameterName() {
        return targetParameterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resources that would be included in the actual runbook execution, if it were to be run.
     * Both Targets and TargetMaps can't be specified together.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return Information about the resources that would be included in the actual runbook execution, if it were to be
     *         run. Both Targets and TargetMaps can't be specified together.
     */
    public final List<Target> targets() {
        return targets;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetMaps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargetMaps() {
        return targetMaps != null && !(targetMaps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be specified
     * together.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetMaps} method.
     * </p>
     * 
     * @return A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
     *         specified together.
     */
    public final List<Map<String, List<String>>> targetMaps() {
        return targetMaps;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetLocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetLocations() {
        return targetLocations != null && !(targetLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the Automation
     * execution preview operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetLocations} method.
     * </p>
     * 
     * @return Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the
     *         Automation execution preview operation.
     */
    public final List<TargetLocation> targetLocations() {
        return targetLocations;
    }

    /**
     * <p>
     * A publicly accessible URL for a file that contains the <code>TargetLocations</code> body. Currently, only files
     * in presigned Amazon S3 buckets are supported.
     * </p>
     * 
     * @return A publicly accessible URL for a file that contains the <code>TargetLocations</code> body. Currently, only
     *         files in presigned Amazon S3 buckets are supported.
     */
    public final String targetLocationsURL() {
        return targetLocationsURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetMaps() ? targetMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetLocations() ? targetLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetLocationsURL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionInputs)) {
            return false;
        }
        AutomationExecutionInputs other = (AutomationExecutionInputs) obj;
        return hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(targetParameterName(), other.targetParameterName()) && hasTargets() == other.hasTargets()
                && Objects.equals(targets(), other.targets()) && hasTargetMaps() == other.hasTargetMaps()
                && Objects.equals(targetMaps(), other.targetMaps()) && hasTargetLocations() == other.hasTargetLocations()
                && Objects.equals(targetLocations(), other.targetLocations())
                && Objects.equals(targetLocationsURL(), other.targetLocationsURL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomationExecutionInputs").add("Parameters", hasParameters() ? parameters() : null)
                .add("TargetParameterName", targetParameterName()).add("Targets", hasTargets() ? targets() : null)
                .add("TargetMaps", hasTargetMaps() ? targetMaps() : null)
                .add("TargetLocations", hasTargetLocations() ? targetLocations() : null)
                .add("TargetLocationsURL", targetLocationsURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "TargetParameterName":
            return Optional.ofNullable(clazz.cast(targetParameterName()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "TargetMaps":
            return Optional.ofNullable(clazz.cast(targetMaps()));
        case "TargetLocations":
            return Optional.ofNullable(clazz.cast(targetLocations()));
        case "TargetLocationsURL":
            return Optional.ofNullable(clazz.cast(targetLocationsURL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("TargetParameterName", TARGET_PARAMETER_NAME_FIELD);
        map.put("Targets", TARGETS_FIELD);
        map.put("TargetMaps", TARGET_MAPS_FIELD);
        map.put("TargetLocations", TARGET_LOCATIONS_FIELD);
        map.put("TargetLocationsURL", TARGET_LOCATIONS_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecutionInputs, T> g) {
        return obj -> g.apply((AutomationExecutionInputs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationExecutionInputs> {
        /**
         * <p>
         * Information about parameters that can be specified for the preview operation.
         * </p>
         * 
         * @param parameters
         *        Information about parameters that can be specified for the preview operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * The name of the parameter used as the target resource for the rate-controlled execution. Required if you
         * specify targets.
         * </p>
         * 
         * @param targetParameterName
         *        The name of the parameter used as the target resource for the rate-controlled execution. Required if
         *        you specify targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetParameterName(String targetParameterName);

        /**
         * <p>
         * Information about the resources that would be included in the actual runbook execution, if it were to be run.
         * Both Targets and TargetMaps can't be specified together.
         * </p>
         * 
         * @param targets
         *        Information about the resources that would be included in the actual runbook execution, if it were to
         *        be run. Both Targets and TargetMaps can't be specified together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * Information about the resources that would be included in the actual runbook execution, if it were to be run.
         * Both Targets and TargetMaps can't be specified together.
         * </p>
         * 
         * @param targets
         *        Information about the resources that would be included in the actual runbook execution, if it were to
         *        be run. Both Targets and TargetMaps can't be specified together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * Information about the resources that would be included in the actual runbook execution, if it were to be run.
         * Both Targets and TargetMaps can't be specified together.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.Target.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ssm.model.Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ssm.model.Target.Builder#build()}
         * is called immediately and its result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ssm.model.Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(java.util.Collection<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
         * specified together.
         * </p>
         * 
         * @param targetMaps
         *        A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
         *        specified together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps);

        /**
         * <p>
         * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
         * specified together.
         * </p>
         * 
         * @param targetMaps
         *        A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
         *        specified together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMaps(Map<String, ? extends Collection<String>>... targetMaps);

        /**
         * <p>
         * Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the Automation
         * execution preview operation.
         * </p>
         * 
         * @param targetLocations
         *        Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the
         *        Automation execution preview operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocations(Collection<TargetLocation> targetLocations);

        /**
         * <p>
         * Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the Automation
         * execution preview operation.
         * </p>
         * 
         * @param targetLocations
         *        Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the
         *        Automation execution preview operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocations(TargetLocation... targetLocations);

        /**
         * <p>
         * Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the Automation
         * execution preview operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.TargetLocation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssm.model.TargetLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.TargetLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #targetLocations(List<TargetLocation>)}.
         * 
         * @param targetLocations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.TargetLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetLocations(java.util.Collection<TargetLocation>)
         */
        Builder targetLocations(Consumer<TargetLocation.Builder>... targetLocations);

        /**
         * <p>
         * A publicly accessible URL for a file that contains the <code>TargetLocations</code> body. Currently, only
         * files in presigned Amazon S3 buckets are supported.
         * </p>
         * 
         * @param targetLocationsURL
         *        A publicly accessible URL for a file that contains the <code>TargetLocations</code> body. Currently,
         *        only files in presigned Amazon S3 buckets are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocationsURL(String targetLocationsURL);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String targetParameterName;

        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();

        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();

        private String targetLocationsURL;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionInputs model) {
            parameters(model.parameters);
            targetParameterName(model.targetParameterName);
            targets(model.targets);
            targetMaps(model.targetMaps);
            targetLocations(model.targetLocations);
            targetLocationsURL(model.targetLocationsURL);
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final String getTargetParameterName() {
            return targetParameterName;
        }

        public final void setTargetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
        }

        @Override
        public final Builder targetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            if (targetMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return targetMaps;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>>... targetMaps) {
            targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final List<TargetLocation.Builder> getTargetLocations() {
            List<TargetLocation.Builder> result = TargetLocationsCopier.copyToBuilder(this.targetLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        @Override
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(TargetLocation... targetLocations) {
            targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder>... targetLocations) {
            targetLocations(Stream.of(targetLocations).map(c -> TargetLocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTargetLocationsURL() {
            return targetLocationsURL;
        }

        public final void setTargetLocationsURL(String targetLocationsURL) {
            this.targetLocationsURL = targetLocationsURL;
        }

        @Override
        public final Builder targetLocationsURL(String targetLocationsURL) {
            this.targetLocationsURL = targetLocationsURL;
            return this;
        }

        @Override
        public AutomationExecutionInputs build() {
            return new AutomationExecutionInputs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
