/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OpsItemStatus {
    OPEN("Open"),
    IN_PROGRESS("InProgress"),
    RESOLVED("Resolved"),
    PENDING("Pending"),
    TIMED_OUT("TimedOut"),
    CANCELLING("Cancelling"),
    CANCELLED("Cancelled"),
    FAILED("Failed"),
    COMPLETED_WITH_SUCCESS("CompletedWithSuccess"),
    COMPLETED_WITH_FAILURE("CompletedWithFailure"),
    SCHEDULED("Scheduled"),
    RUNBOOK_IN_PROGRESS("RunbookInProgress"),
    PENDING_CHANGE_CALENDAR_OVERRIDE("PendingChangeCalendarOverride"),
    CHANGE_CALENDAR_OVERRIDE_APPROVED("ChangeCalendarOverrideApproved"),
    CHANGE_CALENDAR_OVERRIDE_REJECTED("ChangeCalendarOverrideRejected"),
    PENDING_APPROVAL("PendingApproval"),
    APPROVED("Approved"),
    REVOKED("Revoked"),
    REJECTED("Rejected"),
    CLOSED("Closed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpsItemStatus> VALUE_MAP;
    private final String value;

    private OpsItemStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OpsItemStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OpsItemStatus> knownValues() {
        EnumSet<OpsItemStatus> knownValues = EnumSet.allOf(OpsItemStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OpsItemStatus.class, OpsItemStatus::toString);
    }
}

