/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about ownership of a managed node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeOwnerInfo implements SdkPojo, Serializable, ToCopyableBuilder<NodeOwnerInfo.Builder, NodeOwnerInfo> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(NodeOwnerInfo::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationalUnitId").getter(getter(NodeOwnerInfo::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitId").build())
            .build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationalUnitPath").getter(getter(NodeOwnerInfo::organizationalUnitPath))
            .setter(setter(Builder::organizationalUnitPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitPath").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ORGANIZATIONAL_UNIT_ID_FIELD, ORGANIZATIONAL_UNIT_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String organizationalUnitId;

    private final String organizationalUnitPath;

    private NodeOwnerInfo(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.organizationalUnitId = builder.organizationalUnitId;
        this.organizationalUnitPath = builder.organizationalUnitPath;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the managed node.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the managed node.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ID of the organization unit (OU) that the account is part of.
     * </p>
     * 
     * @return The ID of the organization unit (OU) that the account is part of.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    /**
     * <p>
     * The path for the organizational unit (OU) that owns the managed node. The path for the OU is built using the IDs
     * of the organization, root, and all OUs in the path down to and including the OU. For example:
     * </p>
     * <p>
     * <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-ghi0-awsccccc/ou-jkl0-awsddddd/</code>
     * </p>
     * 
     * @return The path for the organizational unit (OU) that owns the managed node. The path for the OU is built using
     *         the IDs of the organization, root, and all OUs in the path down to and including the OU. For example:</p>
     *         <p>
     *         <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-ghi0-awsccccc/ou-jkl0-awsddddd/</code>
     */
    public final String organizationalUnitPath() {
        return organizationalUnitPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeOwnerInfo)) {
            return false;
        }
        NodeOwnerInfo other = (NodeOwnerInfo) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(organizationalUnitId(), other.organizationalUnitId())
                && Objects.equals(organizationalUnitPath(), other.organizationalUnitPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeOwnerInfo").add("AccountId", accountId())
                .add("OrganizationalUnitId", organizationalUnitId()).add("OrganizationalUnitPath", organizationalUnitPath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "OrganizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        case "OrganizationalUnitPath":
            return Optional.ofNullable(clazz.cast(organizationalUnitPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("OrganizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        map.put("OrganizationalUnitPath", ORGANIZATIONAL_UNIT_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeOwnerInfo, T> g) {
        return obj -> g.apply((NodeOwnerInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeOwnerInfo> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the managed node.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account that owns the managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ID of the organization unit (OU) that the account is part of.
         * </p>
         * 
         * @param organizationalUnitId
         *        The ID of the organization unit (OU) that the account is part of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);

        /**
         * <p>
         * The path for the organizational unit (OU) that owns the managed node. The path for the OU is built using the
         * IDs of the organization, root, and all OUs in the path down to and including the OU. For example:
         * </p>
         * <p>
         * <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-ghi0-awsccccc/ou-jkl0-awsddddd/</code>
         * </p>
         * 
         * @param organizationalUnitPath
         *        The path for the organizational unit (OU) that owns the managed node. The path for the OU is built
         *        using the IDs of the organization, root, and all OUs in the path down to and including the OU. For
         *        example:</p>
         *        <p>
         *        <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-ghi0-awsccccc/ou-jkl0-awsddddd/</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitPath(String organizationalUnitPath);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String organizationalUnitId;

        private String organizationalUnitPath;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeOwnerInfo model) {
            accountId(model.accountId);
            organizationalUnitId(model.organizationalUnitId);
            organizationalUnitPath(model.organizationalUnitPath);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public final String getOrganizationalUnitPath() {
            return organizationalUnitPath;
        }

        public final void setOrganizationalUnitPath(String organizationalUnitPath) {
            this.organizationalUnitPath = organizationalUnitPath;
        }

        @Override
        public final Builder organizationalUnitPath(String organizationalUnitPath) {
            this.organizationalUnitPath = organizationalUnitPath;
            return this;
        }

        @Override
        public NodeOwnerInfo build() {
            return new NodeOwnerInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
