/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.BaselineOverride;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeployablePatchSnapshotForInstanceRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GetDeployablePatchSnapshotForInstanceRequest.getter(GetDeployablePatchSnapshotForInstanceRequest::instanceId)).setter(GetDeployablePatchSnapshotForInstanceRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(GetDeployablePatchSnapshotForInstanceRequest.getter(GetDeployablePatchSnapshotForInstanceRequest::snapshotId)).setter(GetDeployablePatchSnapshotForInstanceRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<BaselineOverride> BASELINE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BaselineOverride").getter(GetDeployablePatchSnapshotForInstanceRequest.getter(GetDeployablePatchSnapshotForInstanceRequest::baselineOverride)).setter(GetDeployablePatchSnapshotForInstanceRequest.setter(Builder::baselineOverride)).constructor(BaselineOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, SNAPSHOT_ID_FIELD, BASELINE_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDeployablePatchSnapshotForInstanceRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String snapshotId;
    private final BaselineOverride baselineOverride;

    private GetDeployablePatchSnapshotForInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.snapshotId = builder.snapshotId;
        this.baselineOverride = builder.baselineOverride;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final BaselineOverride baselineOverride() {
        return this.baselineOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeployablePatchSnapshotForInstanceRequest)) {
            return false;
        }
        GetDeployablePatchSnapshotForInstanceRequest other = (GetDeployablePatchSnapshotForInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.baselineOverride(), other.baselineOverride());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeployablePatchSnapshotForInstanceRequest").add("InstanceId", (Object)this.instanceId()).add("SnapshotId", (Object)this.snapshotId()).add("BaselineOverride", (Object)this.baselineOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "BaselineOverride": {
                return Optional.ofNullable(clazz.cast(this.baselineOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("BaselineOverride", BASELINE_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeployablePatchSnapshotForInstanceRequest, T> g) {
        return obj -> g.apply((GetDeployablePatchSnapshotForInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String snapshotId;
        private BaselineOverride baselineOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeployablePatchSnapshotForInstanceRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.snapshotId(model.snapshotId);
            this.baselineOverride(model.baselineOverride);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final BaselineOverride.Builder getBaselineOverride() {
            return this.baselineOverride != null ? this.baselineOverride.toBuilder() : null;
        }

        public final void setBaselineOverride(BaselineOverride.BuilderImpl baselineOverride) {
            this.baselineOverride = baselineOverride != null ? baselineOverride.build() : null;
        }

        @Override
        public final Builder baselineOverride(BaselineOverride baselineOverride) {
            this.baselineOverride = baselineOverride;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDeployablePatchSnapshotForInstanceRequest build() {
            return new GetDeployablePatchSnapshotForInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder snapshotId(String var1);

        public Builder baselineOverride(BaselineOverride var1);

        default public Builder baselineOverride(Consumer<BaselineOverride.Builder> baselineOverride) {
            return this.baselineOverride((BaselineOverride)((BaselineOverride.Builder)BaselineOverride.builder().applyMutation(baselineOverride)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

