/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ScheduledWindowExecution;
import software.amazon.awssdk.services.ssm.model.ScheduledWindowExecutionListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMaintenanceWindowScheduleResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowScheduleResponse> {
    private static final SdkField<List<ScheduledWindowExecution>> SCHEDULED_WINDOW_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduledWindowExecutions").getter(DescribeMaintenanceWindowScheduleResponse.getter(DescribeMaintenanceWindowScheduleResponse::scheduledWindowExecutions)).setter(DescribeMaintenanceWindowScheduleResponse.setter(Builder::scheduledWindowExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledWindowExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledWindowExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMaintenanceWindowScheduleResponse.getter(DescribeMaintenanceWindowScheduleResponse::nextToken)).setter(DescribeMaintenanceWindowScheduleResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_WINDOW_EXECUTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMaintenanceWindowScheduleResponse.memberNameToFieldInitializer();
    private final List<ScheduledWindowExecution> scheduledWindowExecutions;
    private final String nextToken;

    private DescribeMaintenanceWindowScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledWindowExecutions = builder.scheduledWindowExecutions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScheduledWindowExecutions() {
        return this.scheduledWindowExecutions != null && !(this.scheduledWindowExecutions instanceof SdkAutoConstructList);
    }

    public final List<ScheduledWindowExecution> scheduledWindowExecutions() {
        return this.scheduledWindowExecutions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledWindowExecutions() ? this.scheduledWindowExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowScheduleResponse)) {
            return false;
        }
        DescribeMaintenanceWindowScheduleResponse other = (DescribeMaintenanceWindowScheduleResponse)((Object)obj);
        return this.hasScheduledWindowExecutions() == other.hasScheduledWindowExecutions() && Objects.equals(this.scheduledWindowExecutions(), other.scheduledWindowExecutions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMaintenanceWindowScheduleResponse").add("ScheduledWindowExecutions", this.hasScheduledWindowExecutions() ? this.scheduledWindowExecutions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledWindowExecutions": {
                return Optional.ofNullable(clazz.cast(this.scheduledWindowExecutions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScheduledWindowExecutions", SCHEDULED_WINDOW_EXECUTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowScheduleResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowScheduleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<ScheduledWindowExecution> scheduledWindowExecutions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowScheduleResponse model) {
            super(model);
            this.scheduledWindowExecutions(model.scheduledWindowExecutions);
            this.nextToken(model.nextToken);
        }

        public final List<ScheduledWindowExecution.Builder> getScheduledWindowExecutions() {
            List<ScheduledWindowExecution.Builder> result = ScheduledWindowExecutionListCopier.copyToBuilder(this.scheduledWindowExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledWindowExecutions(Collection<ScheduledWindowExecution.BuilderImpl> scheduledWindowExecutions) {
            this.scheduledWindowExecutions = ScheduledWindowExecutionListCopier.copyFromBuilder(scheduledWindowExecutions);
        }

        @Override
        public final Builder scheduledWindowExecutions(Collection<ScheduledWindowExecution> scheduledWindowExecutions) {
            this.scheduledWindowExecutions = ScheduledWindowExecutionListCopier.copy(scheduledWindowExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledWindowExecutions(ScheduledWindowExecution ... scheduledWindowExecutions) {
            this.scheduledWindowExecutions(Arrays.asList(scheduledWindowExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledWindowExecutions(Consumer<ScheduledWindowExecution.Builder> ... scheduledWindowExecutions) {
            this.scheduledWindowExecutions(Stream.of(scheduledWindowExecutions).map(c -> (ScheduledWindowExecution)((ScheduledWindowExecution.Builder)ScheduledWindowExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMaintenanceWindowScheduleResponse build() {
            return new DescribeMaintenanceWindowScheduleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMaintenanceWindowScheduleResponse> {
        public Builder scheduledWindowExecutions(Collection<ScheduledWindowExecution> var1);

        public Builder scheduledWindowExecutions(ScheduledWindowExecution ... var1);

        public Builder scheduledWindowExecutions(Consumer<ScheduledWindowExecution.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

