/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class PatchOrchestratorFilterListCopier {
    static List<PatchOrchestratorFilter> copy(Collection<? extends PatchOrchestratorFilter> patchOrchestratorFilterListParam) {
        List<PatchOrchestratorFilter> list;
        if (patchOrchestratorFilterListParam == null || patchOrchestratorFilterListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PatchOrchestratorFilter> modifiableList = new ArrayList<>(patchOrchestratorFilterListParam.size());
            patchOrchestratorFilterListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PatchOrchestratorFilter> copyFromBuilder(
            Collection<? extends PatchOrchestratorFilter.Builder> patchOrchestratorFilterListParam) {
        List<PatchOrchestratorFilter> list;
        if (patchOrchestratorFilterListParam == null || patchOrchestratorFilterListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PatchOrchestratorFilter> modifiableList = new ArrayList<>(patchOrchestratorFilterListParam.size());
            patchOrchestratorFilterListParam.forEach(entry -> {
                PatchOrchestratorFilter member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PatchOrchestratorFilter.Builder> copyToBuilder(
            Collection<? extends PatchOrchestratorFilter> patchOrchestratorFilterListParam) {
        List<PatchOrchestratorFilter.Builder> list;
        if (patchOrchestratorFilterListParam == null || patchOrchestratorFilterListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PatchOrchestratorFilter.Builder> modifiableList = new ArrayList<>(patchOrchestratorFilterListParam.size());
            patchOrchestratorFilterListParam.forEach(entry -> {
                PatchOrchestratorFilter.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
