/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstancePatchStatesForPatchGroupRequest extends SsmRequest
        implements
        ToCopyableBuilder<DescribeInstancePatchStatesForPatchGroupRequest.Builder, DescribeInstancePatchStatesForPatchGroupRequest> {
    private static final SdkField<String> PATCH_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchGroup").getter(getter(DescribeInstancePatchStatesForPatchGroupRequest::patchGroup))
            .setter(setter(Builder::patchGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchGroup").build()).build();

    private static final SdkField<List<InstancePatchStateFilter>> FILTERS_FIELD = SdkField
            .<List<InstancePatchStateFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeInstancePatchStatesForPatchGroupRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstancePatchStateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstancePatchStateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeInstancePatchStatesForPatchGroupRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeInstancePatchStatesForPatchGroupRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCH_GROUP_FIELD,
            FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String patchGroup;

    private final List<InstancePatchStateFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeInstancePatchStatesForPatchGroupRequest(BuilderImpl builder) {
        super(builder);
        this.patchGroup = builder.patchGroup;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The name of the patch group for which the patch state information should be retrieved.
     * </p>
     * 
     * @return The name of the patch group for which the patch state information should be retrieved.
     */
    public final String patchGroup() {
        return patchGroup;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each entry in the array is a structure containing:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key (string between 1 and 200 characters)
     * </p>
     * </li>
     * <li>
     * <p>
     * Values (array containing a single string)
     * </p>
     * </li>
     * <li>
     * <p>
     * Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Each entry in the array is a structure containing:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key (string between 1 and 200 characters)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Values (array containing a single string)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
     *         </p>
     *         </li>
     */
    public final List<InstancePatchStateFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of patches to return (per page).
     * </p>
     * 
     * @return The maximum number of patches to return (per page).
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(patchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchStatesForPatchGroupRequest)) {
            return false;
        }
        DescribeInstancePatchStatesForPatchGroupRequest other = (DescribeInstancePatchStatesForPatchGroupRequest) obj;
        return Objects.equals(patchGroup(), other.patchGroup()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstancePatchStatesForPatchGroupRequest").add("PatchGroup", patchGroup())
                .add("Filters", hasFilters() ? filters() : null).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatchGroup":
            return Optional.ofNullable(clazz.cast(patchGroup()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PatchGroup", PATCH_GROUP_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancePatchStatesForPatchGroupRequest, T> g) {
        return obj -> g.apply((DescribeInstancePatchStatesForPatchGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstancePatchStatesForPatchGroupRequest> {
        /**
         * <p>
         * The name of the patch group for which the patch state information should be retrieved.
         * </p>
         * 
         * @param patchGroup
         *        The name of the patch group for which the patch state information should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key (string between 1 and 200 characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * Values (array containing a single string)
         * </p>
         * </li>
         * <li>
         * <p>
         * Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Each entry in the array is a structure containing:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key (string between 1 and 200 characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Values (array containing a single string)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<InstancePatchStateFilter> filters);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key (string between 1 and 200 characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * Values (array containing a single string)
         * </p>
         * </li>
         * <li>
         * <p>
         * Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Each entry in the array is a structure containing:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key (string between 1 and 200 characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Values (array containing a single string)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(InstancePatchStateFilter... filters);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key (string between 1 and 200 characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * Values (array containing a single string)
         * </p>
         * </li>
         * <li>
         * <p>
         * Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.InstancePatchStateFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ssm.model.InstancePatchStateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.InstancePatchStateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<InstancePatchStateFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.InstancePatchStateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<InstancePatchStateFilter>)
         */
        Builder filters(Consumer<InstancePatchStateFilter.Builder>... filters);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of patches to return (per page).
         * </p>
         * 
         * @param maxResults
         *        The maximum number of patches to return (per page).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String patchGroup;

        private List<InstancePatchStateFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchStatesForPatchGroupRequest model) {
            super(model);
            patchGroup(model.patchGroup);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final List<InstancePatchStateFilter.Builder> getFilters() {
            List<InstancePatchStateFilter.Builder> result = InstancePatchStateFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<InstancePatchStateFilter.BuilderImpl> filters) {
            this.filters = InstancePatchStateFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<InstancePatchStateFilter> filters) {
            this.filters = InstancePatchStateFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InstancePatchStateFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<InstancePatchStateFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> InstancePatchStateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancePatchStatesForPatchGroupRequest build() {
            return new DescribeInstancePatchStatesForPatchGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
