/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.Activation;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse;

public class DescribeActivationsIterable
implements SdkIterable<DescribeActivationsResponse> {
    private final SsmClient client;
    private final DescribeActivationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeActivationsIterable(SsmClient client, DescribeActivationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeActivationsResponseFetcher();
    }

    public Iterator<DescribeActivationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Activation> activationList() {
        Function<DescribeActivationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.activationList() != null) {
                return response.activationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeActivationsResponseFetcher
    implements SyncPageFetcher<DescribeActivationsResponse> {
        private DescribeActivationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeActivationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeActivationsResponse nextPage(DescribeActivationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeActivationsIterable.this.client.describeActivations(DescribeActivationsIterable.this.firstRequest);
            }
            return DescribeActivationsIterable.this.client.describeActivations((DescribeActivationsRequest)((Object)DescribeActivationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

