/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A default version of a document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentDefaultVersionDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentDefaultVersionDescription.Builder, DocumentDefaultVersionDescription> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DocumentDefaultVersionDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DEFAULT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultVersion").getter(getter(DocumentDefaultVersionDescription::defaultVersion))
            .setter(setter(Builder::defaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersion").build()).build();

    private static final SdkField<String> DEFAULT_VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultVersionName").getter(getter(DocumentDefaultVersionDescription::defaultVersionName))
            .setter(setter(Builder::defaultVersionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DEFAULT_VERSION_FIELD, DEFAULT_VERSION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String defaultVersion;

    private final String defaultVersionName;

    private DocumentDefaultVersionDescription(BuilderImpl builder) {
        this.name = builder.name;
        this.defaultVersion = builder.defaultVersion;
        this.defaultVersionName = builder.defaultVersionName;
    }

    /**
     * <p>
     * The name of the document.
     * </p>
     * 
     * @return The name of the document.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The default version of the document.
     * </p>
     * 
     * @return The default version of the document.
     */
    public final String defaultVersion() {
        return defaultVersion;
    }

    /**
     * <p>
     * The default version of the artifact associated with the document.
     * </p>
     * 
     * @return The default version of the artifact associated with the document.
     */
    public final String defaultVersionName() {
        return defaultVersionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentDefaultVersionDescription)) {
            return false;
        }
        DocumentDefaultVersionDescription other = (DocumentDefaultVersionDescription) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(defaultVersion(), other.defaultVersion())
                && Objects.equals(defaultVersionName(), other.defaultVersionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentDefaultVersionDescription").add("Name", name()).add("DefaultVersion", defaultVersion())
                .add("DefaultVersionName", defaultVersionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DefaultVersion":
            return Optional.ofNullable(clazz.cast(defaultVersion()));
        case "DefaultVersionName":
            return Optional.ofNullable(clazz.cast(defaultVersionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("DefaultVersion", DEFAULT_VERSION_FIELD);
        map.put("DefaultVersionName", DEFAULT_VERSION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentDefaultVersionDescription, T> g) {
        return obj -> g.apply((DocumentDefaultVersionDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentDefaultVersionDescription> {
        /**
         * <p>
         * The name of the document.
         * </p>
         * 
         * @param name
         *        The name of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The default version of the document.
         * </p>
         * 
         * @param defaultVersion
         *        The default version of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersion(String defaultVersion);

        /**
         * <p>
         * The default version of the artifact associated with the document.
         * </p>
         * 
         * @param defaultVersionName
         *        The default version of the artifact associated with the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionName(String defaultVersionName);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String defaultVersion;

        private String defaultVersionName;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentDefaultVersionDescription model) {
            name(model.name);
            defaultVersion(model.defaultVersion);
            defaultVersionName(model.defaultVersionName);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDefaultVersion() {
            return defaultVersion;
        }

        public final void setDefaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        @Override
        public final Builder defaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final String getDefaultVersionName() {
            return defaultVersionName;
        }

        public final void setDefaultVersionName(String defaultVersionName) {
            this.defaultVersionName = defaultVersionName;
        }

        @Override
        public final Builder defaultVersionName(String defaultVersionName) {
            this.defaultVersionName = defaultVersionName;
            return this;
        }

        @Override
        public DocumentDefaultVersionDescription build() {
            return new DocumentDefaultVersionDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
