/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing various properties of a managed node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceProperty.Builder, InstanceProperty> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(InstanceProperty::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(InstanceProperty::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(InstanceProperty::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> INSTANCE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceRole").getter(getter(InstanceProperty::instanceRole)).setter(setter(Builder::instanceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRole").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyName").getter(getter(InstanceProperty::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()).build();

    private static final SdkField<String> INSTANCE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceState").getter(getter(InstanceProperty::instanceState)).setter(setter(Builder::instanceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceState").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Architecture").getter(getter(InstanceProperty::architecture)).setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IPAddress").getter(getter(InstanceProperty::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddress").build()).build();

    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LaunchTime").getter(getter(InstanceProperty::launchTime)).setter(setter(Builder::launchTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").build()).build();

    private static final SdkField<String> PING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PingStatus").getter(getter(InstanceProperty::pingStatusAsString)).setter(setter(Builder::pingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingStatus").build()).build();

    private static final SdkField<Instant> LAST_PING_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastPingDateTime").getter(getter(InstanceProperty::lastPingDateTime))
            .setter(setter(Builder::lastPingDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastPingDateTime").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentVersion").getter(getter(InstanceProperty::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()).build();

    private static final SdkField<String> PLATFORM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformType").getter(getter(InstanceProperty::platformTypeAsString))
            .setter(setter(Builder::platformType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformType").build()).build();

    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformName").getter(getter(InstanceProperty::platformName)).setter(setter(Builder::platformName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformVersion").getter(getter(InstanceProperty::platformVersion))
            .setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()).build();

    private static final SdkField<String> ACTIVATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationId").getter(getter(InstanceProperty::activationId)).setter(setter(Builder::activationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationId").build()).build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRole").getter(getter(InstanceProperty::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()).build();

    private static final SdkField<Instant> REGISTRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RegistrationDate").getter(getter(InstanceProperty::registrationDate))
            .setter(setter(Builder::registrationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationDate").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(InstanceProperty::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputerName").getter(getter(InstanceProperty::computerName)).setter(setter(Builder::computerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()).build();

    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationStatus").getter(getter(InstanceProperty::associationStatus))
            .setter(setter(Builder::associationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()).build();

    private static final SdkField<Instant> LAST_ASSOCIATION_EXECUTION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAssociationExecutionDate")
            .getter(getter(InstanceProperty::lastAssociationExecutionDate))
            .setter(setter(Builder::lastAssociationExecutionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAssociationExecutionDate")
                    .build()).build();

    private static final SdkField<Instant> LAST_SUCCESSFUL_ASSOCIATION_EXECUTION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSuccessfulAssociationExecutionDate")
            .getter(getter(InstanceProperty::lastSuccessfulAssociationExecutionDate))
            .setter(setter(Builder::lastSuccessfulAssociationExecutionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LastSuccessfulAssociationExecutionDate").build()).build();

    private static final SdkField<InstanceAggregatedAssociationOverview> ASSOCIATION_OVERVIEW_FIELD = SdkField
            .<InstanceAggregatedAssociationOverview> builder(MarshallingType.SDK_POJO).memberName("AssociationOverview")
            .getter(getter(InstanceProperty::associationOverview)).setter(setter(Builder::associationOverview))
            .constructor(InstanceAggregatedAssociationOverview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationOverview").build())
            .build();

    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceId").getter(getter(InstanceProperty::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(InstanceProperty::sourceTypeAsString)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INSTANCE_ID_FIELD,
            INSTANCE_TYPE_FIELD, INSTANCE_ROLE_FIELD, KEY_NAME_FIELD, INSTANCE_STATE_FIELD, ARCHITECTURE_FIELD, IP_ADDRESS_FIELD,
            LAUNCH_TIME_FIELD, PING_STATUS_FIELD, LAST_PING_DATE_TIME_FIELD, AGENT_VERSION_FIELD, PLATFORM_TYPE_FIELD,
            PLATFORM_NAME_FIELD, PLATFORM_VERSION_FIELD, ACTIVATION_ID_FIELD, IAM_ROLE_FIELD, REGISTRATION_DATE_FIELD,
            RESOURCE_TYPE_FIELD, COMPUTER_NAME_FIELD, ASSOCIATION_STATUS_FIELD, LAST_ASSOCIATION_EXECUTION_DATE_FIELD,
            LAST_SUCCESSFUL_ASSOCIATION_EXECUTION_DATE_FIELD, ASSOCIATION_OVERVIEW_FIELD, SOURCE_ID_FIELD, SOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String instanceId;

    private final String instanceType;

    private final String instanceRole;

    private final String keyName;

    private final String instanceState;

    private final String architecture;

    private final String ipAddress;

    private final Instant launchTime;

    private final String pingStatus;

    private final Instant lastPingDateTime;

    private final String agentVersion;

    private final String platformType;

    private final String platformName;

    private final String platformVersion;

    private final String activationId;

    private final String iamRole;

    private final Instant registrationDate;

    private final String resourceType;

    private final String computerName;

    private final String associationStatus;

    private final Instant lastAssociationExecutionDate;

    private final Instant lastSuccessfulAssociationExecutionDate;

    private final InstanceAggregatedAssociationOverview associationOverview;

    private final String sourceId;

    private final String sourceType;

    private InstanceProperty(BuilderImpl builder) {
        this.name = builder.name;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.instanceRole = builder.instanceRole;
        this.keyName = builder.keyName;
        this.instanceState = builder.instanceState;
        this.architecture = builder.architecture;
        this.ipAddress = builder.ipAddress;
        this.launchTime = builder.launchTime;
        this.pingStatus = builder.pingStatus;
        this.lastPingDateTime = builder.lastPingDateTime;
        this.agentVersion = builder.agentVersion;
        this.platformType = builder.platformType;
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.activationId = builder.activationId;
        this.iamRole = builder.iamRole;
        this.registrationDate = builder.registrationDate;
        this.resourceType = builder.resourceType;
        this.computerName = builder.computerName;
        this.associationStatus = builder.associationStatus;
        this.lastAssociationExecutionDate = builder.lastAssociationExecutionDate;
        this.lastSuccessfulAssociationExecutionDate = builder.lastSuccessfulAssociationExecutionDate;
        this.associationOverview = builder.associationOverview;
        this.sourceId = builder.sourceId;
        this.sourceType = builder.sourceType;
    }

    /**
     * <p>
     * The value of the EC2 <code>Name</code> tag associated with the node. If a <code>Name</code> tag hasn't been
     * applied to the node, this value is blank.
     * </p>
     * 
     * @return The value of the EC2 <code>Name</code> tag associated with the node. If a <code>Name</code> tag hasn't
     *         been applied to the node, this value is blank.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the managed node.
     * </p>
     * 
     * @return The ID of the managed node.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type of the managed node. For example, t3.large.
     * </p>
     * 
     * @return The instance type of the managed node. For example, t3.large.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The instance profile attached to the node. If an instance profile isn't attached to the node, this value is
     * blank.
     * </p>
     * 
     * @return The instance profile attached to the node. If an instance profile isn't attached to the node, this value
     *         is blank.
     */
    public final String instanceRole() {
        return instanceRole;
    }

    /**
     * <p>
     * The name of the key pair associated with the node. If a key pair isnt't associated with the node, this value is
     * blank.
     * </p>
     * 
     * @return The name of the key pair associated with the node. If a key pair isnt't associated with the node, this
     *         value is blank.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The current state of the node.
     * </p>
     * 
     * @return The current state of the node.
     */
    public final String instanceState() {
        return instanceState;
    }

    /**
     * <p>
     * The CPU architecture of the node. For example, x86_64.
     * </p>
     * 
     * @return The CPU architecture of the node. For example, x86_64.
     */
    public final String architecture() {
        return architecture;
    }

    /**
     * <p>
     * The public IPv4 address assigned to the node. If a public IPv4 address isn't assigned to the node, this value is
     * blank.
     * </p>
     * 
     * @return The public IPv4 address assigned to the node. If a public IPv4 address isn't assigned to the node, this
     *         value is blank.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The timestamp for when the node was launched.
     * </p>
     * 
     * @return The timestamp for when the node was launched.
     */
    public final Instant launchTime() {
        return launchTime;
    }

    /**
     * <p>
     * Connection status of the SSM Agent on the managed node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pingStatus} will
     * return {@link PingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pingStatusAsString}.
     * </p>
     * 
     * @return Connection status of the SSM Agent on the managed node.
     * @see PingStatus
     */
    public final PingStatus pingStatus() {
        return PingStatus.fromValue(pingStatus);
    }

    /**
     * <p>
     * Connection status of the SSM Agent on the managed node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pingStatus} will
     * return {@link PingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pingStatusAsString}.
     * </p>
     * 
     * @return Connection status of the SSM Agent on the managed node.
     * @see PingStatus
     */
    public final String pingStatusAsString() {
        return pingStatus;
    }

    /**
     * <p>
     * The date and time when the SSM Agent last pinged the Systems Manager service.
     * </p>
     * 
     * @return The date and time when the SSM Agent last pinged the Systems Manager service.
     */
    public final Instant lastPingDateTime() {
        return lastPingDateTime;
    }

    /**
     * <p>
     * The version of SSM Agent running on your managed node.
     * </p>
     * 
     * @return The version of SSM Agent running on your managed node.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * The operating system platform type of the managed node. For example, Windows.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformType} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformTypeAsString}.
     * </p>
     * 
     * @return The operating system platform type of the managed node. For example, Windows.
     * @see PlatformType
     */
    public final PlatformType platformType() {
        return PlatformType.fromValue(platformType);
    }

    /**
     * <p>
     * The operating system platform type of the managed node. For example, Windows.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformType} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformTypeAsString}.
     * </p>
     * 
     * @return The operating system platform type of the managed node. For example, Windows.
     * @see PlatformType
     */
    public final String platformTypeAsString() {
        return platformType;
    }

    /**
     * <p>
     * The name of the operating system platform running on your managed node.
     * </p>
     * 
     * @return The name of the operating system platform running on your managed node.
     */
    public final String platformName() {
        return platformName;
    }

    /**
     * <p>
     * The version of the OS platform running on your managed node.
     * </p>
     * 
     * @return The version of the OS platform running on your managed node.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The activation ID created by Systems Manager when the server or virtual machine (VM) was registered
     * </p>
     * 
     * @return The activation ID created by Systems Manager when the server or virtual machine (VM) was registered
     */
    public final String activationId() {
        return activationId;
    }

    /**
     * <p>
     * The IAM role used in the hybrid activation to register the node with Systems Manager.
     * </p>
     * 
     * @return The IAM role used in the hybrid activation to register the node with Systems Manager.
     */
    public final String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * The date the node was registered with Systems Manager.
     * </p>
     * 
     * @return The date the node was registered with Systems Manager.
     */
    public final Instant registrationDate() {
        return registrationDate;
    }

    /**
     * <p>
     * The type of managed node.
     * </p>
     * 
     * @return The type of managed node.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The fully qualified host name of the managed node.
     * </p>
     * 
     * @return The fully qualified host name of the managed node.
     */
    public final String computerName() {
        return computerName;
    }

    /**
     * <p>
     * The status of the State Manager association applied to the managed node.
     * </p>
     * 
     * @return The status of the State Manager association applied to the managed node.
     */
    public final String associationStatus() {
        return associationStatus;
    }

    /**
     * <p>
     * The date the association was last run.
     * </p>
     * 
     * @return The date the association was last run.
     */
    public final Instant lastAssociationExecutionDate() {
        return lastAssociationExecutionDate;
    }

    /**
     * <p>
     * The last date the association was successfully run.
     * </p>
     * 
     * @return The last date the association was successfully run.
     */
    public final Instant lastSuccessfulAssociationExecutionDate() {
        return lastSuccessfulAssociationExecutionDate;
    }

    /**
     * Returns the value of the AssociationOverview property for this object.
     * 
     * @return The value of the AssociationOverview property for this object.
     */
    public final InstanceAggregatedAssociationOverview associationOverview() {
        return associationOverview;
    }

    /**
     * <p>
     * The ID of the source resource.
     * </p>
     * 
     * @return The ID of the source resource.
     */
    public final String sourceId() {
        return sourceId;
    }

    /**
     * <p>
     * The type of the source resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of the source resource.
     * @see SourceType
     */
    public final SourceType sourceType() {
        return SourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The type of the source resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of the source resource.
     * @see SourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRole());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceState());
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(pingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastPingDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(platformTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformName());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(activationId());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(registrationDate());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(computerName());
        hashCode = 31 * hashCode + Objects.hashCode(associationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(lastAssociationExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulAssociationExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(associationOverview());
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceProperty)) {
            return false;
        }
        InstanceProperty other = (InstanceProperty) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(instanceRole(), other.instanceRole())
                && Objects.equals(keyName(), other.keyName()) && Objects.equals(instanceState(), other.instanceState())
                && Objects.equals(architecture(), other.architecture()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(launchTime(), other.launchTime())
                && Objects.equals(pingStatusAsString(), other.pingStatusAsString())
                && Objects.equals(lastPingDateTime(), other.lastPingDateTime())
                && Objects.equals(agentVersion(), other.agentVersion())
                && Objects.equals(platformTypeAsString(), other.platformTypeAsString())
                && Objects.equals(platformName(), other.platformName())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(activationId(), other.activationId()) && Objects.equals(iamRole(), other.iamRole())
                && Objects.equals(registrationDate(), other.registrationDate())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(computerName(), other.computerName())
                && Objects.equals(associationStatus(), other.associationStatus())
                && Objects.equals(lastAssociationExecutionDate(), other.lastAssociationExecutionDate())
                && Objects.equals(lastSuccessfulAssociationExecutionDate(), other.lastSuccessfulAssociationExecutionDate())
                && Objects.equals(associationOverview(), other.associationOverview())
                && Objects.equals(sourceId(), other.sourceId())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceProperty").add("Name", name()).add("InstanceId", instanceId())
                .add("InstanceType", instanceType()).add("InstanceRole", instanceRole()).add("KeyName", keyName())
                .add("InstanceState", instanceState()).add("Architecture", architecture()).add("IPAddress", ipAddress())
                .add("LaunchTime", launchTime()).add("PingStatus", pingStatusAsString())
                .add("LastPingDateTime", lastPingDateTime()).add("AgentVersion", agentVersion())
                .add("PlatformType", platformTypeAsString()).add("PlatformName", platformName())
                .add("PlatformVersion", platformVersion()).add("ActivationId", activationId()).add("IamRole", iamRole())
                .add("RegistrationDate", registrationDate()).add("ResourceType", resourceType())
                .add("ComputerName", computerName()).add("AssociationStatus", associationStatus())
                .add("LastAssociationExecutionDate", lastAssociationExecutionDate())
                .add("LastSuccessfulAssociationExecutionDate", lastSuccessfulAssociationExecutionDate())
                .add("AssociationOverview", associationOverview()).add("SourceId", sourceId())
                .add("SourceType", sourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "InstanceRole":
            return Optional.ofNullable(clazz.cast(instanceRole()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "InstanceState":
            return Optional.ofNullable(clazz.cast(instanceState()));
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        case "IPAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "LaunchTime":
            return Optional.ofNullable(clazz.cast(launchTime()));
        case "PingStatus":
            return Optional.ofNullable(clazz.cast(pingStatusAsString()));
        case "LastPingDateTime":
            return Optional.ofNullable(clazz.cast(lastPingDateTime()));
        case "AgentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "PlatformType":
            return Optional.ofNullable(clazz.cast(platformTypeAsString()));
        case "PlatformName":
            return Optional.ofNullable(clazz.cast(platformName()));
        case "PlatformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "ActivationId":
            return Optional.ofNullable(clazz.cast(activationId()));
        case "IamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "RegistrationDate":
            return Optional.ofNullable(clazz.cast(registrationDate()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ComputerName":
            return Optional.ofNullable(clazz.cast(computerName()));
        case "AssociationStatus":
            return Optional.ofNullable(clazz.cast(associationStatus()));
        case "LastAssociationExecutionDate":
            return Optional.ofNullable(clazz.cast(lastAssociationExecutionDate()));
        case "LastSuccessfulAssociationExecutionDate":
            return Optional.ofNullable(clazz.cast(lastSuccessfulAssociationExecutionDate()));
        case "AssociationOverview":
            return Optional.ofNullable(clazz.cast(associationOverview()));
        case "SourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceProperty, T> g) {
        return obj -> g.apply((InstanceProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceProperty> {
        /**
         * <p>
         * The value of the EC2 <code>Name</code> tag associated with the node. If a <code>Name</code> tag hasn't been
         * applied to the node, this value is blank.
         * </p>
         * 
         * @param name
         *        The value of the EC2 <code>Name</code> tag associated with the node. If a <code>Name</code> tag hasn't
         *        been applied to the node, this value is blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the managed node.
         * </p>
         * 
         * @param instanceId
         *        The ID of the managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type of the managed node. For example, t3.large.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the managed node. For example, t3.large.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance profile attached to the node. If an instance profile isn't attached to the node, this value is
         * blank.
         * </p>
         * 
         * @param instanceRole
         *        The instance profile attached to the node. If an instance profile isn't attached to the node, this
         *        value is blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRole(String instanceRole);

        /**
         * <p>
         * The name of the key pair associated with the node. If a key pair isnt't associated with the node, this value
         * is blank.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair associated with the node. If a key pair isnt't associated with the node, this
         *        value is blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The current state of the node.
         * </p>
         * 
         * @param instanceState
         *        The current state of the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceState(String instanceState);

        /**
         * <p>
         * The CPU architecture of the node. For example, x86_64.
         * </p>
         * 
         * @param architecture
         *        The CPU architecture of the node. For example, x86_64.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The public IPv4 address assigned to the node. If a public IPv4 address isn't assigned to the node, this value
         * is blank.
         * </p>
         * 
         * @param ipAddress
         *        The public IPv4 address assigned to the node. If a public IPv4 address isn't assigned to the node,
         *        this value is blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The timestamp for when the node was launched.
         * </p>
         * 
         * @param launchTime
         *        The timestamp for when the node was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(Instant launchTime);

        /**
         * <p>
         * Connection status of the SSM Agent on the managed node.
         * </p>
         * 
         * @param pingStatus
         *        Connection status of the SSM Agent on the managed node.
         * @see PingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PingStatus
         */
        Builder pingStatus(String pingStatus);

        /**
         * <p>
         * Connection status of the SSM Agent on the managed node.
         * </p>
         * 
         * @param pingStatus
         *        Connection status of the SSM Agent on the managed node.
         * @see PingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PingStatus
         */
        Builder pingStatus(PingStatus pingStatus);

        /**
         * <p>
         * The date and time when the SSM Agent last pinged the Systems Manager service.
         * </p>
         * 
         * @param lastPingDateTime
         *        The date and time when the SSM Agent last pinged the Systems Manager service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastPingDateTime(Instant lastPingDateTime);

        /**
         * <p>
         * The version of SSM Agent running on your managed node.
         * </p>
         * 
         * @param agentVersion
         *        The version of SSM Agent running on your managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * The operating system platform type of the managed node. For example, Windows.
         * </p>
         * 
         * @param platformType
         *        The operating system platform type of the managed node. For example, Windows.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platformType(String platformType);

        /**
         * <p>
         * The operating system platform type of the managed node. For example, Windows.
         * </p>
         * 
         * @param platformType
         *        The operating system platform type of the managed node. For example, Windows.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platformType(PlatformType platformType);

        /**
         * <p>
         * The name of the operating system platform running on your managed node.
         * </p>
         * 
         * @param platformName
         *        The name of the operating system platform running on your managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformName(String platformName);

        /**
         * <p>
         * The version of the OS platform running on your managed node.
         * </p>
         * 
         * @param platformVersion
         *        The version of the OS platform running on your managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The activation ID created by Systems Manager when the server or virtual machine (VM) was registered
         * </p>
         * 
         * @param activationId
         *        The activation ID created by Systems Manager when the server or virtual machine (VM) was registered
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationId(String activationId);

        /**
         * <p>
         * The IAM role used in the hybrid activation to register the node with Systems Manager.
         * </p>
         * 
         * @param iamRole
         *        The IAM role used in the hybrid activation to register the node with Systems Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * The date the node was registered with Systems Manager.
         * </p>
         * 
         * @param registrationDate
         *        The date the node was registered with Systems Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationDate(Instant registrationDate);

        /**
         * <p>
         * The type of managed node.
         * </p>
         * 
         * @param resourceType
         *        The type of managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The fully qualified host name of the managed node.
         * </p>
         * 
         * @param computerName
         *        The fully qualified host name of the managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerName(String computerName);

        /**
         * <p>
         * The status of the State Manager association applied to the managed node.
         * </p>
         * 
         * @param associationStatus
         *        The status of the State Manager association applied to the managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationStatus(String associationStatus);

        /**
         * <p>
         * The date the association was last run.
         * </p>
         * 
         * @param lastAssociationExecutionDate
         *        The date the association was last run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAssociationExecutionDate(Instant lastAssociationExecutionDate);

        /**
         * <p>
         * The last date the association was successfully run.
         * </p>
         * 
         * @param lastSuccessfulAssociationExecutionDate
         *        The last date the association was successfully run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate);

        /**
         * Sets the value of the AssociationOverview property for this object.
         *
         * @param associationOverview
         *        The new value for the AssociationOverview property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationOverview(InstanceAggregatedAssociationOverview associationOverview);

        /**
         * Sets the value of the AssociationOverview property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link InstanceAggregatedAssociationOverview.Builder} avoiding the need to create one manually via
         * {@link InstanceAggregatedAssociationOverview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceAggregatedAssociationOverview.Builder#build()} is called
         * immediately and its result is passed to {@link #associationOverview(InstanceAggregatedAssociationOverview)}.
         * 
         * @param associationOverview
         *        a consumer that will call methods on {@link InstanceAggregatedAssociationOverview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationOverview(InstanceAggregatedAssociationOverview)
         */
        default Builder associationOverview(Consumer<InstanceAggregatedAssociationOverview.Builder> associationOverview) {
            return associationOverview(InstanceAggregatedAssociationOverview.builder().applyMutation(associationOverview).build());
        }

        /**
         * <p>
         * The ID of the source resource.
         * </p>
         * 
         * @param sourceId
         *        The ID of the source resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(String sourceId);

        /**
         * <p>
         * The type of the source resource.
         * </p>
         * 
         * @param sourceType
         *        The type of the source resource.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The type of the source resource.
         * </p>
         * 
         * @param sourceType
         *        The type of the source resource.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(SourceType sourceType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String instanceId;

        private String instanceType;

        private String instanceRole;

        private String keyName;

        private String instanceState;

        private String architecture;

        private String ipAddress;

        private Instant launchTime;

        private String pingStatus;

        private Instant lastPingDateTime;

        private String agentVersion;

        private String platformType;

        private String platformName;

        private String platformVersion;

        private String activationId;

        private String iamRole;

        private Instant registrationDate;

        private String resourceType;

        private String computerName;

        private String associationStatus;

        private Instant lastAssociationExecutionDate;

        private Instant lastSuccessfulAssociationExecutionDate;

        private InstanceAggregatedAssociationOverview associationOverview;

        private String sourceId;

        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceProperty model) {
            name(model.name);
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            instanceRole(model.instanceRole);
            keyName(model.keyName);
            instanceState(model.instanceState);
            architecture(model.architecture);
            ipAddress(model.ipAddress);
            launchTime(model.launchTime);
            pingStatus(model.pingStatus);
            lastPingDateTime(model.lastPingDateTime);
            agentVersion(model.agentVersion);
            platformType(model.platformType);
            platformName(model.platformName);
            platformVersion(model.platformVersion);
            activationId(model.activationId);
            iamRole(model.iamRole);
            registrationDate(model.registrationDate);
            resourceType(model.resourceType);
            computerName(model.computerName);
            associationStatus(model.associationStatus);
            lastAssociationExecutionDate(model.lastAssociationExecutionDate);
            lastSuccessfulAssociationExecutionDate(model.lastSuccessfulAssociationExecutionDate);
            associationOverview(model.associationOverview);
            sourceId(model.sourceId);
            sourceType(model.sourceType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getInstanceRole() {
            return instanceRole;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getInstanceState() {
            return instanceState;
        }

        public final void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        @Override
        public final Builder instanceState(String instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final Instant getLaunchTime() {
            return launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final String getPingStatus() {
            return pingStatus;
        }

        public final void setPingStatus(String pingStatus) {
            this.pingStatus = pingStatus;
        }

        @Override
        public final Builder pingStatus(String pingStatus) {
            this.pingStatus = pingStatus;
            return this;
        }

        @Override
        public final Builder pingStatus(PingStatus pingStatus) {
            this.pingStatus(pingStatus == null ? null : pingStatus.toString());
            return this;
        }

        public final Instant getLastPingDateTime() {
            return lastPingDateTime;
        }

        public final void setLastPingDateTime(Instant lastPingDateTime) {
            this.lastPingDateTime = lastPingDateTime;
        }

        @Override
        public final Builder lastPingDateTime(Instant lastPingDateTime) {
            this.lastPingDateTime = lastPingDateTime;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getPlatformType() {
            return platformType;
        }

        public final void setPlatformType(String platformType) {
            this.platformType = platformType;
        }

        @Override
        public final Builder platformType(String platformType) {
            this.platformType = platformType;
            return this;
        }

        @Override
        public final Builder platformType(PlatformType platformType) {
            this.platformType(platformType == null ? null : platformType.toString());
            return this;
        }

        public final String getPlatformName() {
            return platformName;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getActivationId() {
            return activationId;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final String getIamRole() {
            return iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final Instant getRegistrationDate() {
            return registrationDate;
        }

        public final void setRegistrationDate(Instant registrationDate) {
            this.registrationDate = registrationDate;
        }

        @Override
        public final Builder registrationDate(Instant registrationDate) {
            this.registrationDate = registrationDate;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getComputerName() {
            return computerName;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final String getAssociationStatus() {
            return associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        public final Instant getLastAssociationExecutionDate() {
            return lastAssociationExecutionDate;
        }

        public final void setLastAssociationExecutionDate(Instant lastAssociationExecutionDate) {
            this.lastAssociationExecutionDate = lastAssociationExecutionDate;
        }

        @Override
        public final Builder lastAssociationExecutionDate(Instant lastAssociationExecutionDate) {
            this.lastAssociationExecutionDate = lastAssociationExecutionDate;
            return this;
        }

        public final Instant getLastSuccessfulAssociationExecutionDate() {
            return lastSuccessfulAssociationExecutionDate;
        }

        public final void setLastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate) {
            this.lastSuccessfulAssociationExecutionDate = lastSuccessfulAssociationExecutionDate;
        }

        @Override
        public final Builder lastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate) {
            this.lastSuccessfulAssociationExecutionDate = lastSuccessfulAssociationExecutionDate;
            return this;
        }

        public final InstanceAggregatedAssociationOverview.Builder getAssociationOverview() {
            return associationOverview != null ? associationOverview.toBuilder() : null;
        }

        public final void setAssociationOverview(InstanceAggregatedAssociationOverview.BuilderImpl associationOverview) {
            this.associationOverview = associationOverview != null ? associationOverview.build() : null;
        }

        @Override
        public final Builder associationOverview(InstanceAggregatedAssociationOverview associationOverview) {
            this.associationOverview = associationOverview;
            return this;
        }

        public final String getSourceId() {
            return sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        @Override
        public InstanceProperty build() {
            return new InstanceProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
