/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about comments added to a document review request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentReviewCommentSource implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentReviewCommentSource.Builder, DocumentReviewCommentSource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DocumentReviewCommentSource::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(DocumentReviewCommentSource::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String content;

    private DocumentReviewCommentSource(BuilderImpl builder) {
        this.type = builder.type;
        this.content = builder.content;
    }

    /**
     * <p>
     * The type of information added to a review request. Currently, only the value <code>Comment</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DocumentReviewCommentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of information added to a review request. Currently, only the value <code>Comment</code> is
     *         supported.
     * @see DocumentReviewCommentType
     */
    public final DocumentReviewCommentType type() {
        return DocumentReviewCommentType.fromValue(type);
    }

    /**
     * <p>
     * The type of information added to a review request. Currently, only the value <code>Comment</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DocumentReviewCommentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of information added to a review request. Currently, only the value <code>Comment</code> is
     *         supported.
     * @see DocumentReviewCommentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The content of a comment entered by a user who requests a review of a new document version, or who reviews the
     * new version.
     * </p>
     * 
     * @return The content of a comment entered by a user who requests a review of a new document version, or who
     *         reviews the new version.
     */
    public final String content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentReviewCommentSource)) {
            return false;
        }
        DocumentReviewCommentSource other = (DocumentReviewCommentSource) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentReviewCommentSource").add("Type", typeAsString()).add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentReviewCommentSource, T> g) {
        return obj -> g.apply((DocumentReviewCommentSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentReviewCommentSource> {
        /**
         * <p>
         * The type of information added to a review request. Currently, only the value <code>Comment</code> is
         * supported.
         * </p>
         * 
         * @param type
         *        The type of information added to a review request. Currently, only the value <code>Comment</code> is
         *        supported.
         * @see DocumentReviewCommentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentReviewCommentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of information added to a review request. Currently, only the value <code>Comment</code> is
         * supported.
         * </p>
         * 
         * @param type
         *        The type of information added to a review request. Currently, only the value <code>Comment</code> is
         *        supported.
         * @see DocumentReviewCommentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentReviewCommentType
         */
        Builder type(DocumentReviewCommentType type);

        /**
         * <p>
         * The content of a comment entered by a user who requests a review of a new document version, or who reviews
         * the new version.
         * </p>
         * 
         * @param content
         *        The content of a comment entered by a user who requests a review of a new document version, or who
         *        reviews the new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentReviewCommentSource model) {
            type(model.type);
            content(model.content);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DocumentReviewCommentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        @Override
        public DocumentReviewCommentSource build() {
            return new DocumentReviewCommentSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
