/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.OpsItemDataValue;
import software.amazon.awssdk.services.ssm.model.OpsItemOperationalDataCopier;
import software.amazon.awssdk.services.ssm.model.OpsItemStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpsItemSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpsItemSummary> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(OpsItemSummary.getter(OpsItemSummary::createdBy)).setter(OpsItemSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(OpsItemSummary.getter(OpsItemSummary::createdTime)).setter(OpsItemSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(OpsItemSummary.getter(OpsItemSummary::lastModifiedBy)).setter(OpsItemSummary.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(OpsItemSummary.getter(OpsItemSummary::lastModifiedTime)).setter(OpsItemSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(OpsItemSummary.getter(OpsItemSummary::priority)).setter(OpsItemSummary.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(OpsItemSummary.getter(OpsItemSummary::source)).setter(OpsItemSummary.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(OpsItemSummary.getter(OpsItemSummary::statusAsString)).setter(OpsItemSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemId").getter(OpsItemSummary.getter(OpsItemSummary::opsItemId)).setter(OpsItemSummary.setter(Builder::opsItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(OpsItemSummary.getter(OpsItemSummary::title)).setter(OpsItemSummary.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<Map<String, OpsItemDataValue>> OPERATIONAL_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OperationalData").getter(OpsItemSummary.getter(OpsItemSummary::operationalData)).setter(OpsItemSummary.setter(Builder::operationalData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationalData").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemDataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(OpsItemSummary.getter(OpsItemSummary::category)).setter(OpsItemSummary.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(OpsItemSummary.getter(OpsItemSummary::severity)).setter(OpsItemSummary.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> OPS_ITEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemType").getter(OpsItemSummary.getter(OpsItemSummary::opsItemType)).setter(OpsItemSummary.setter(Builder::opsItemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemType").build()}).build();
    private static final SdkField<Instant> ACTUAL_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActualStartTime").getter(OpsItemSummary.getter(OpsItemSummary::actualStartTime)).setter(OpsItemSummary.setter(Builder::actualStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualStartTime").build()}).build();
    private static final SdkField<Instant> ACTUAL_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActualEndTime").getter(OpsItemSummary.getter(OpsItemSummary::actualEndTime)).setter(OpsItemSummary.setter(Builder::actualEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualEndTime").build()}).build();
    private static final SdkField<Instant> PLANNED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PlannedStartTime").getter(OpsItemSummary.getter(OpsItemSummary::plannedStartTime)).setter(OpsItemSummary.setter(Builder::plannedStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlannedStartTime").build()}).build();
    private static final SdkField<Instant> PLANNED_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PlannedEndTime").getter(OpsItemSummary.getter(OpsItemSummary::plannedEndTime)).setter(OpsItemSummary.setter(Builder::plannedEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlannedEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, PRIORITY_FIELD, SOURCE_FIELD, STATUS_FIELD, OPS_ITEM_ID_FIELD, TITLE_FIELD, OPERATIONAL_DATA_FIELD, CATEGORY_FIELD, SEVERITY_FIELD, OPS_ITEM_TYPE_FIELD, ACTUAL_START_TIME_FIELD, ACTUAL_END_TIME_FIELD, PLANNED_START_TIME_FIELD, PLANNED_END_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String createdBy;
    private final Instant createdTime;
    private final String lastModifiedBy;
    private final Instant lastModifiedTime;
    private final Integer priority;
    private final String source;
    private final String status;
    private final String opsItemId;
    private final String title;
    private final Map<String, OpsItemDataValue> operationalData;
    private final String category;
    private final String severity;
    private final String opsItemType;
    private final Instant actualStartTime;
    private final Instant actualEndTime;
    private final Instant plannedStartTime;
    private final Instant plannedEndTime;

    private OpsItemSummary(BuilderImpl builder) {
        this.createdBy = builder.createdBy;
        this.createdTime = builder.createdTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.priority = builder.priority;
        this.source = builder.source;
        this.status = builder.status;
        this.opsItemId = builder.opsItemId;
        this.title = builder.title;
        this.operationalData = builder.operationalData;
        this.category = builder.category;
        this.severity = builder.severity;
        this.opsItemType = builder.opsItemType;
        this.actualStartTime = builder.actualStartTime;
        this.actualEndTime = builder.actualEndTime;
        this.plannedStartTime = builder.plannedStartTime;
        this.plannedEndTime = builder.plannedEndTime;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final String source() {
        return this.source;
    }

    public final OpsItemStatus status() {
        return OpsItemStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String opsItemId() {
        return this.opsItemId;
    }

    public final String title() {
        return this.title;
    }

    public final boolean hasOperationalData() {
        return this.operationalData != null && !(this.operationalData instanceof SdkAutoConstructMap);
    }

    public final Map<String, OpsItemDataValue> operationalData() {
        return this.operationalData;
    }

    public final String category() {
        return this.category;
    }

    public final String severity() {
        return this.severity;
    }

    public final String opsItemType() {
        return this.opsItemType;
    }

    public final Instant actualStartTime() {
        return this.actualStartTime;
    }

    public final Instant actualEndTime() {
        return this.actualEndTime;
    }

    public final Instant plannedStartTime() {
        return this.plannedStartTime;
    }

    public final Instant plannedEndTime() {
        return this.plannedEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationalData() ? this.operationalData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemType());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.plannedStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.plannedEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsItemSummary)) {
            return false;
        }
        OpsItemSummary other = (OpsItemSummary)obj;
        return Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.opsItemId(), other.opsItemId()) && Objects.equals(this.title(), other.title()) && this.hasOperationalData() == other.hasOperationalData() && Objects.equals(this.operationalData(), other.operationalData()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.opsItemType(), other.opsItemType()) && Objects.equals(this.actualStartTime(), other.actualStartTime()) && Objects.equals(this.actualEndTime(), other.actualEndTime()) && Objects.equals(this.plannedStartTime(), other.plannedStartTime()) && Objects.equals(this.plannedEndTime(), other.plannedEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"OpsItemSummary").add("CreatedBy", (Object)this.createdBy()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Priority", (Object)this.priority()).add("Source", (Object)this.source()).add("Status", (Object)this.statusAsString()).add("OpsItemId", (Object)this.opsItemId()).add("Title", (Object)this.title()).add("OperationalData", this.hasOperationalData() ? this.operationalData() : null).add("Category", (Object)this.category()).add("Severity", (Object)this.severity()).add("OpsItemType", (Object)this.opsItemType()).add("ActualStartTime", (Object)this.actualStartTime()).add("ActualEndTime", (Object)this.actualEndTime()).add("PlannedStartTime", (Object)this.plannedStartTime()).add("PlannedEndTime", (Object)this.plannedEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "OpsItemId": {
                return Optional.ofNullable(clazz.cast(this.opsItemId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "OperationalData": {
                return Optional.ofNullable(clazz.cast(this.operationalData()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "OpsItemType": {
                return Optional.ofNullable(clazz.cast(this.opsItemType()));
            }
            case "ActualStartTime": {
                return Optional.ofNullable(clazz.cast(this.actualStartTime()));
            }
            case "ActualEndTime": {
                return Optional.ofNullable(clazz.cast(this.actualEndTime()));
            }
            case "PlannedStartTime": {
                return Optional.ofNullable(clazz.cast(this.plannedStartTime()));
            }
            case "PlannedEndTime": {
                return Optional.ofNullable(clazz.cast(this.plannedEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpsItemSummary, T> g) {
        return obj -> g.apply((OpsItemSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String createdBy;
        private Instant createdTime;
        private String lastModifiedBy;
        private Instant lastModifiedTime;
        private Integer priority;
        private String source;
        private String status;
        private String opsItemId;
        private String title;
        private Map<String, OpsItemDataValue> operationalData = DefaultSdkAutoConstructMap.getInstance();
        private String category;
        private String severity;
        private String opsItemType;
        private Instant actualStartTime;
        private Instant actualEndTime;
        private Instant plannedStartTime;
        private Instant plannedEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OpsItemSummary model) {
            this.createdBy(model.createdBy);
            this.createdTime(model.createdTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.priority(model.priority);
            this.source(model.source);
            this.status(model.status);
            this.opsItemId(model.opsItemId);
            this.title(model.title);
            this.operationalData(model.operationalData);
            this.category(model.category);
            this.severity(model.severity);
            this.opsItemType(model.opsItemType);
            this.actualStartTime(model.actualStartTime);
            this.actualEndTime(model.actualEndTime);
            this.plannedStartTime(model.plannedStartTime);
            this.plannedEndTime(model.plannedEndTime);
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        @Transient
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        @Transient
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        @Transient
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(OpsItemStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOpsItemId() {
            return this.opsItemId;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        @Override
        @Transient
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Map<String, OpsItemDataValue.Builder> getOperationalData() {
            Map<String, OpsItemDataValue.Builder> result = OpsItemOperationalDataCopier.copyToBuilder(this.operationalData);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOperationalData(Map<String, OpsItemDataValue.BuilderImpl> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copyFromBuilder(operationalData);
        }

        @Override
        @Transient
        public final Builder operationalData(Map<String, OpsItemDataValue> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copy(operationalData);
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        @Transient
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        @Transient
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final String getOpsItemType() {
            return this.opsItemType;
        }

        public final void setOpsItemType(String opsItemType) {
            this.opsItemType = opsItemType;
        }

        @Override
        @Transient
        public final Builder opsItemType(String opsItemType) {
            this.opsItemType = opsItemType;
            return this;
        }

        public final Instant getActualStartTime() {
            return this.actualStartTime;
        }

        public final void setActualStartTime(Instant actualStartTime) {
            this.actualStartTime = actualStartTime;
        }

        @Override
        @Transient
        public final Builder actualStartTime(Instant actualStartTime) {
            this.actualStartTime = actualStartTime;
            return this;
        }

        public final Instant getActualEndTime() {
            return this.actualEndTime;
        }

        public final void setActualEndTime(Instant actualEndTime) {
            this.actualEndTime = actualEndTime;
        }

        @Override
        @Transient
        public final Builder actualEndTime(Instant actualEndTime) {
            this.actualEndTime = actualEndTime;
            return this;
        }

        public final Instant getPlannedStartTime() {
            return this.plannedStartTime;
        }

        public final void setPlannedStartTime(Instant plannedStartTime) {
            this.plannedStartTime = plannedStartTime;
        }

        @Override
        @Transient
        public final Builder plannedStartTime(Instant plannedStartTime) {
            this.plannedStartTime = plannedStartTime;
            return this;
        }

        public final Instant getPlannedEndTime() {
            return this.plannedEndTime;
        }

        public final void setPlannedEndTime(Instant plannedEndTime) {
            this.plannedEndTime = plannedEndTime;
        }

        @Override
        @Transient
        public final Builder plannedEndTime(Instant plannedEndTime) {
            this.plannedEndTime = plannedEndTime;
            return this;
        }

        public OpsItemSummary build() {
            return new OpsItemSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpsItemSummary> {
        public Builder createdBy(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder priority(Integer var1);

        public Builder source(String var1);

        public Builder status(String var1);

        public Builder status(OpsItemStatus var1);

        public Builder opsItemId(String var1);

        public Builder title(String var1);

        public Builder operationalData(Map<String, OpsItemDataValue> var1);

        public Builder category(String var1);

        public Builder severity(String var1);

        public Builder opsItemType(String var1);

        public Builder actualStartTime(Instant var1);

        public Builder actualEndTime(Instant var1);

        public Builder plannedStartTime(Instant var1);

        public Builder plannedEndTime(Instant var1);
    }
}

