/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeployablePatchSnapshotForInstanceResponse extends SsmResponse implements
        ToCopyableBuilder<GetDeployablePatchSnapshotForInstanceResponse.Builder, GetDeployablePatchSnapshotForInstanceResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(GetDeployablePatchSnapshotForInstanceResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(GetDeployablePatchSnapshotForInstanceResponse::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<String> SNAPSHOT_DOWNLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotDownloadUrl").getter(getter(GetDeployablePatchSnapshotForInstanceResponse::snapshotDownloadUrl))
            .setter(setter(Builder::snapshotDownloadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotDownloadUrl").build())
            .build();

    private static final SdkField<String> PRODUCT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Product")
            .getter(getter(GetDeployablePatchSnapshotForInstanceResponse::product)).setter(setter(Builder::product))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            SNAPSHOT_ID_FIELD, SNAPSHOT_DOWNLOAD_URL_FIELD, PRODUCT_FIELD));

    private final String instanceId;

    private final String snapshotId;

    private final String snapshotDownloadUrl;

    private final String product;

    private GetDeployablePatchSnapshotForInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.snapshotId = builder.snapshotId;
        this.snapshotDownloadUrl = builder.snapshotDownloadUrl;
        this.product = builder.product;
    }

    /**
     * <p>
     * The managed node ID.
     * </p>
     * 
     * @return The managed node ID.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The user-defined snapshot ID.
     * </p>
     * 
     * @return The user-defined snapshot ID.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * A pre-signed Amazon Simple Storage Service (Amazon S3) URL that can be used to download the patch snapshot.
     * </p>
     * 
     * @return A pre-signed Amazon Simple Storage Service (Amazon S3) URL that can be used to download the patch
     *         snapshot.
     */
    public final String snapshotDownloadUrl() {
        return snapshotDownloadUrl;
    }

    /**
     * <p>
     * Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the managed
     * node for the specified patch snapshot.
     * </p>
     * 
     * @return Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the
     *         managed node for the specified patch snapshot.
     */
    public final String product() {
        return product;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotDownloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(product());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeployablePatchSnapshotForInstanceResponse)) {
            return false;
        }
        GetDeployablePatchSnapshotForInstanceResponse other = (GetDeployablePatchSnapshotForInstanceResponse) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(snapshotDownloadUrl(), other.snapshotDownloadUrl())
                && Objects.equals(product(), other.product());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeployablePatchSnapshotForInstanceResponse").add("InstanceId", instanceId())
                .add("SnapshotId", snapshotId()).add("SnapshotDownloadUrl", snapshotDownloadUrl()).add("Product", product())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "SnapshotDownloadUrl":
            return Optional.ofNullable(clazz.cast(snapshotDownloadUrl()));
        case "Product":
            return Optional.ofNullable(clazz.cast(product()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeployablePatchSnapshotForInstanceResponse, T> g) {
        return obj -> g.apply((GetDeployablePatchSnapshotForInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceResponse> {
        /**
         * <p>
         * The managed node ID.
         * </p>
         * 
         * @param instanceId
         *        The managed node ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The user-defined snapshot ID.
         * </p>
         * 
         * @param snapshotId
         *        The user-defined snapshot ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * A pre-signed Amazon Simple Storage Service (Amazon S3) URL that can be used to download the patch snapshot.
         * </p>
         * 
         * @param snapshotDownloadUrl
         *        A pre-signed Amazon Simple Storage Service (Amazon S3) URL that can be used to download the patch
         *        snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotDownloadUrl(String snapshotDownloadUrl);

        /**
         * <p>
         * Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the
         * managed node for the specified patch snapshot.
         * </p>
         * 
         * @param product
         *        Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the
         *        managed node for the specified patch snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(String product);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String instanceId;

        private String snapshotId;

        private String snapshotDownloadUrl;

        private String product;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeployablePatchSnapshotForInstanceResponse model) {
            super(model);
            instanceId(model.instanceId);
            snapshotId(model.snapshotId);
            snapshotDownloadUrl(model.snapshotDownloadUrl);
            product(model.product);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getSnapshotDownloadUrl() {
            return snapshotDownloadUrl;
        }

        public final void setSnapshotDownloadUrl(String snapshotDownloadUrl) {
            this.snapshotDownloadUrl = snapshotDownloadUrl;
        }

        @Override
        public final Builder snapshotDownloadUrl(String snapshotDownloadUrl) {
            this.snapshotDownloadUrl = snapshotDownloadUrl;
            return this;
        }

        public final String getProduct() {
            return product;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        @Override
        public GetDeployablePatchSnapshotForInstanceResponse build() {
            return new GetDeployablePatchSnapshotForInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
