/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.ReviewStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReviewInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReviewInformation> {
    private static final SdkField<Instant> REVIEWED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReviewedTime").getter(ReviewInformation.getter(ReviewInformation::reviewedTime)).setter(ReviewInformation.setter(Builder::reviewedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewedTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReviewInformation.getter(ReviewInformation::statusAsString)).setter(ReviewInformation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> REVIEWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reviewer").getter(ReviewInformation.getter(ReviewInformation::reviewer)).setter(ReviewInformation.setter(Builder::reviewer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reviewer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVIEWED_TIME_FIELD, STATUS_FIELD, REVIEWER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant reviewedTime;
    private final String status;
    private final String reviewer;

    private ReviewInformation(BuilderImpl builder) {
        this.reviewedTime = builder.reviewedTime;
        this.status = builder.status;
        this.reviewer = builder.reviewer;
    }

    public final Instant reviewedTime() {
        return this.reviewedTime;
    }

    public final ReviewStatus status() {
        return ReviewStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String reviewer() {
        return this.reviewer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewInformation)) {
            return false;
        }
        ReviewInformation other = (ReviewInformation)obj;
        return Objects.equals(this.reviewedTime(), other.reviewedTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.reviewer(), other.reviewer());
    }

    public final String toString() {
        return ToString.builder((String)"ReviewInformation").add("ReviewedTime", (Object)this.reviewedTime()).add("Status", (Object)this.statusAsString()).add("Reviewer", (Object)this.reviewer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReviewedTime": {
                return Optional.ofNullable(clazz.cast(this.reviewedTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Reviewer": {
                return Optional.ofNullable(clazz.cast(this.reviewer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReviewInformation, T> g) {
        return obj -> g.apply((ReviewInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant reviewedTime;
        private String status;
        private String reviewer;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewInformation model) {
            this.reviewedTime(model.reviewedTime);
            this.status(model.status);
            this.reviewer(model.reviewer);
        }

        public final Instant getReviewedTime() {
            return this.reviewedTime;
        }

        public final void setReviewedTime(Instant reviewedTime) {
            this.reviewedTime = reviewedTime;
        }

        @Override
        public final Builder reviewedTime(Instant reviewedTime) {
            this.reviewedTime = reviewedTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getReviewer() {
            return this.reviewer;
        }

        public final void setReviewer(String reviewer) {
            this.reviewer = reviewer;
        }

        @Override
        public final Builder reviewer(String reviewer) {
            this.reviewer = reviewer;
            return this;
        }

        public ReviewInformation build() {
            return new ReviewInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReviewInformation> {
        public Builder reviewedTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ReviewStatus var1);

        public Builder reviewer(String var1);
    }
}

