/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary;
import software.amazon.awssdk.services.ssm.model.ComplianceSeverity;
import software.amazon.awssdk.services.ssm.model.ComplianceStatus;
import software.amazon.awssdk.services.ssm.model.CompliantSummary;
import software.amazon.awssdk.services.ssm.model.NonCompliantSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceComplianceSummaryItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceComplianceSummaryItem> {
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceType").getter(ResourceComplianceSummaryItem.getter(ResourceComplianceSummaryItem::complianceType)).setter(ResourceComplianceSummaryItem.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceComplianceSummaryItem.getter(ResourceComplianceSummaryItem::resourceType)).setter(ResourceComplianceSummaryItem.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ResourceComplianceSummaryItem.getter(ResourceComplianceSummaryItem::resourceId)).setter(ResourceComplianceSummaryItem.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ResourceComplianceSummaryItem.getter(ResourceComplianceSummaryItem::statusAsString)).setter(ResourceComplianceSummaryItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> OVERALL_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OverallSeverity").getter(ResourceComplianceSummaryItem.getter(ResourceComplianceSummaryItem::overallSeverityAsString)).setter(ResourceComplianceSummaryItem.setter(Builder::overallSeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverallSeverity").build()}).build();
    private static final SdkField<ComplianceExecutionSummary> EXECUTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionSummary").getter(ResourceComplianceSummaryItem.getter(ResourceComplianceSummaryItem::executionSummary)).setter(ResourceComplianceSummaryItem.setter(Builder::executionSummary)).constructor(ComplianceExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionSummary").build()}).build();
    private static final SdkField<CompliantSummary> COMPLIANT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompliantSummary").getter(ResourceComplianceSummaryItem.getter(ResourceComplianceSummaryItem::compliantSummary)).setter(ResourceComplianceSummaryItem.setter(Builder::compliantSummary)).constructor(CompliantSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantSummary").build()}).build();
    private static final SdkField<NonCompliantSummary> NON_COMPLIANT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NonCompliantSummary").getter(ResourceComplianceSummaryItem.getter(ResourceComplianceSummaryItem::nonCompliantSummary)).setter(ResourceComplianceSummaryItem.setter(Builder::nonCompliantSummary)).constructor(NonCompliantSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_TYPE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, STATUS_FIELD, OVERALL_SEVERITY_FIELD, EXECUTION_SUMMARY_FIELD, COMPLIANT_SUMMARY_FIELD, NON_COMPLIANT_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String complianceType;
    private final String resourceType;
    private final String resourceId;
    private final String status;
    private final String overallSeverity;
    private final ComplianceExecutionSummary executionSummary;
    private final CompliantSummary compliantSummary;
    private final NonCompliantSummary nonCompliantSummary;

    private ResourceComplianceSummaryItem(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.status = builder.status;
        this.overallSeverity = builder.overallSeverity;
        this.executionSummary = builder.executionSummary;
        this.compliantSummary = builder.compliantSummary;
        this.nonCompliantSummary = builder.nonCompliantSummary;
    }

    public final String complianceType() {
        return this.complianceType;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final ComplianceStatus status() {
        return ComplianceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ComplianceSeverity overallSeverity() {
        return ComplianceSeverity.fromValue(this.overallSeverity);
    }

    public final String overallSeverityAsString() {
        return this.overallSeverity;
    }

    public final ComplianceExecutionSummary executionSummary() {
        return this.executionSummary;
    }

    public final CompliantSummary compliantSummary() {
        return this.compliantSummary;
    }

    public final NonCompliantSummary nonCompliantSummary() {
        return this.nonCompliantSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.overallSeverityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceComplianceSummaryItem)) {
            return false;
        }
        ResourceComplianceSummaryItem other = (ResourceComplianceSummaryItem)obj;
        return Objects.equals(this.complianceType(), other.complianceType()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.overallSeverityAsString(), other.overallSeverityAsString()) && Objects.equals(this.executionSummary(), other.executionSummary()) && Objects.equals(this.compliantSummary(), other.compliantSummary()) && Objects.equals(this.nonCompliantSummary(), other.nonCompliantSummary());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceComplianceSummaryItem").add("ComplianceType", (Object)this.complianceType()).add("ResourceType", (Object)this.resourceType()).add("ResourceId", (Object)this.resourceId()).add("Status", (Object)this.statusAsString()).add("OverallSeverity", (Object)this.overallSeverityAsString()).add("ExecutionSummary", (Object)this.executionSummary()).add("CompliantSummary", (Object)this.compliantSummary()).add("NonCompliantSummary", (Object)this.nonCompliantSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceType()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "OverallSeverity": {
                return Optional.ofNullable(clazz.cast(this.overallSeverityAsString()));
            }
            case "ExecutionSummary": {
                return Optional.ofNullable(clazz.cast(this.executionSummary()));
            }
            case "CompliantSummary": {
                return Optional.ofNullable(clazz.cast(this.compliantSummary()));
            }
            case "NonCompliantSummary": {
                return Optional.ofNullable(clazz.cast(this.nonCompliantSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceComplianceSummaryItem, T> g) {
        return obj -> g.apply((ResourceComplianceSummaryItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String complianceType;
        private String resourceType;
        private String resourceId;
        private String status;
        private String overallSeverity;
        private ComplianceExecutionSummary executionSummary;
        private CompliantSummary compliantSummary;
        private NonCompliantSummary nonCompliantSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceComplianceSummaryItem model) {
            this.complianceType(model.complianceType);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.status(model.status);
            this.overallSeverity(model.overallSeverity);
            this.executionSummary(model.executionSummary);
            this.compliantSummary(model.compliantSummary);
            this.nonCompliantSummary(model.nonCompliantSummary);
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComplianceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOverallSeverity() {
            return this.overallSeverity;
        }

        public final void setOverallSeverity(String overallSeverity) {
            this.overallSeverity = overallSeverity;
        }

        @Override
        public final Builder overallSeverity(String overallSeverity) {
            this.overallSeverity = overallSeverity;
            return this;
        }

        @Override
        public final Builder overallSeverity(ComplianceSeverity overallSeverity) {
            this.overallSeverity(overallSeverity == null ? null : overallSeverity.toString());
            return this;
        }

        public final ComplianceExecutionSummary.Builder getExecutionSummary() {
            return this.executionSummary != null ? this.executionSummary.toBuilder() : null;
        }

        public final void setExecutionSummary(ComplianceExecutionSummary.BuilderImpl executionSummary) {
            this.executionSummary = executionSummary != null ? executionSummary.build() : null;
        }

        @Override
        public final Builder executionSummary(ComplianceExecutionSummary executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final CompliantSummary.Builder getCompliantSummary() {
            return this.compliantSummary != null ? this.compliantSummary.toBuilder() : null;
        }

        public final void setCompliantSummary(CompliantSummary.BuilderImpl compliantSummary) {
            this.compliantSummary = compliantSummary != null ? compliantSummary.build() : null;
        }

        @Override
        public final Builder compliantSummary(CompliantSummary compliantSummary) {
            this.compliantSummary = compliantSummary;
            return this;
        }

        public final NonCompliantSummary.Builder getNonCompliantSummary() {
            return this.nonCompliantSummary != null ? this.nonCompliantSummary.toBuilder() : null;
        }

        public final void setNonCompliantSummary(NonCompliantSummary.BuilderImpl nonCompliantSummary) {
            this.nonCompliantSummary = nonCompliantSummary != null ? nonCompliantSummary.build() : null;
        }

        @Override
        public final Builder nonCompliantSummary(NonCompliantSummary nonCompliantSummary) {
            this.nonCompliantSummary = nonCompliantSummary;
            return this;
        }

        public ResourceComplianceSummaryItem build() {
            return new ResourceComplianceSummaryItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceComplianceSummaryItem> {
        public Builder complianceType(String var1);

        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder status(String var1);

        public Builder status(ComplianceStatus var1);

        public Builder overallSeverity(String var1);

        public Builder overallSeverity(ComplianceSeverity var1);

        public Builder executionSummary(ComplianceExecutionSummary var1);

        default public Builder executionSummary(Consumer<ComplianceExecutionSummary.Builder> executionSummary) {
            return this.executionSummary((ComplianceExecutionSummary)((ComplianceExecutionSummary.Builder)ComplianceExecutionSummary.builder().applyMutation(executionSummary)).build());
        }

        public Builder compliantSummary(CompliantSummary var1);

        default public Builder compliantSummary(Consumer<CompliantSummary.Builder> compliantSummary) {
            return this.compliantSummary((CompliantSummary)((CompliantSummary.Builder)CompliantSummary.builder().applyMutation(compliantSummary)).build());
        }

        public Builder nonCompliantSummary(NonCompliantSummary var1);

        default public Builder nonCompliantSummary(Consumer<NonCompliantSummary.Builder> nonCompliantSummary) {
            return this.nonCompliantSummary((NonCompliantSummary)((NonCompliantSummary.Builder)NonCompliantSummary.builder().applyMutation(nonCompliantSummary)).build());
        }
    }
}

