/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sqs.internal.batchmanager.BatchingExecutionContext;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestPayloadCalculator;

@SdkInternalApi
public final class RequestBatchBuffer<RequestT, ResponseT> {
    private final Object flushLock = new Object();
    private final Map<String, BatchingExecutionContext<RequestT, ResponseT>> idToBatchContext = new ConcurrentHashMap<String, BatchingExecutionContext<RequestT, ResponseT>>();
    private final int maxBatchItems;
    private final int maxBufferSize;
    private final int maxBatchSizeInBytes;
    private int nextId = 0;
    private int nextBatchEntry = 0;
    private ScheduledFuture<?> scheduledFlush;

    public RequestBatchBuffer(ScheduledFuture<?> scheduledFlush, int maxBatchItems, int maxBatchSizeInBytes, int maxBufferSize) {
        this.scheduledFlush = scheduledFlush;
        this.maxBatchItems = maxBatchItems;
        this.maxBufferSize = maxBufferSize;
        this.maxBatchSizeInBytes = maxBatchSizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BatchingExecutionContext<RequestT, ResponseT>> flushableRequests() {
        Object object = this.flushLock;
        synchronized (object) {
            return this.isByteSizeThresholdCrossed(0) || this.isMaxBatchSizeLimitReached() ? this.extractFlushedEntries(this.maxBatchItems) : Collections.emptyMap();
        }
    }

    private boolean isMaxBatchSizeLimitReached() {
        return this.idToBatchContext.size() >= this.maxBatchItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BatchingExecutionContext<RequestT, ResponseT>> flushableRequestsOnByteLimitBeforeAdd(RequestT request) {
        Object object = this.flushLock;
        synchronized (object) {
            int incomingRequestBytes;
            if (this.maxBatchSizeInBytes > 0 && !this.idToBatchContext.isEmpty() && this.isByteSizeThresholdCrossed(incomingRequestBytes = RequestPayloadCalculator.calculateMessageSize(request).orElse(0).intValue())) {
                return this.extractFlushedEntries(this.maxBatchItems);
            }
            return Collections.emptyMap();
        }
    }

    private boolean isByteSizeThresholdCrossed(int incomingRequestBytes) {
        if (this.maxBatchSizeInBytes < 0) {
            return false;
        }
        int totalPayloadSize = this.idToBatchContext.values().stream().map(BatchingExecutionContext::responsePayloadByteSize).mapToInt(opt -> opt.orElse(0)).sum() + incomingRequestBytes;
        return totalPayloadSize > this.maxBatchSizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BatchingExecutionContext<RequestT, ResponseT>> flushableScheduledRequests(int maxBatchItems) {
        Object object = this.flushLock;
        synchronized (object) {
            if (!this.idToBatchContext.isEmpty()) {
                return this.extractFlushedEntries(maxBatchItems);
            }
            return Collections.emptyMap();
        }
    }

    private Map<String, BatchingExecutionContext<RequestT, ResponseT>> extractFlushedEntries(int maxBatchItems) {
        LinkedHashMap<String, BatchingExecutionContext<RequestT, ResponseT>> requestEntries = new LinkedHashMap<String, BatchingExecutionContext<RequestT, ResponseT>>();
        while (requestEntries.size() < maxBatchItems && this.hasNextBatchEntry()) {
            String nextEntry = this.nextBatchEntry();
            requestEntries.put(nextEntry, this.idToBatchContext.get(nextEntry));
            this.idToBatchContext.remove(nextEntry);
        }
        return requestEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestT request, CompletableFuture<ResponseT> response) {
        RequestBatchBuffer requestBatchBuffer = this;
        synchronized (requestBatchBuffer) {
            if (this.idToBatchContext.size() == this.maxBufferSize) {
                throw new IllegalStateException("Reached MaxBufferSize of: " + this.maxBufferSize);
            }
            if (this.nextId == Integer.MAX_VALUE) {
                this.nextId = 0;
            }
            String id = Integer.toString(this.nextId++);
            this.idToBatchContext.put(id, new BatchingExecutionContext<RequestT, ResponseT>(request, response));
        }
    }

    private boolean hasNextBatchEntry() {
        return this.idToBatchContext.containsKey(Integer.toString(this.nextBatchEntry));
    }

    private String nextBatchEntry() {
        if (this.nextBatchEntry == Integer.MAX_VALUE) {
            this.nextBatchEntry = 0;
        }
        return Integer.toString(this.nextBatchEntry++);
    }

    public void putScheduledFlush(ScheduledFuture<?> scheduledFlush) {
        this.scheduledFlush = scheduledFlush;
    }

    public void cancelScheduledFlush() {
        this.scheduledFlush.cancel(false);
    }

    public Collection<CompletableFuture<ResponseT>> responses() {
        return this.idToBatchContext.values().stream().map(BatchingExecutionContext::response).collect(Collectors.toList());
    }

    public void clear() {
        this.idToBatchContext.clear();
    }
}

