/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sns.model.MessageAttributeMapCopier;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishRequest
extends SnsRequest
implements ToCopyableBuilder<Builder, PublishRequest> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(PublishRequest.getter(PublishRequest::topicArn)).setter(PublishRequest.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetArn").getter(PublishRequest.getter(PublishRequest::targetArn)).setter(PublishRequest.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(PublishRequest.getter(PublishRequest::phoneNumber)).setter(PublishRequest.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(PublishRequest.getter(PublishRequest::message)).setter(PublishRequest.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(PublishRequest.getter(PublishRequest::subject)).setter(PublishRequest.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> MESSAGE_STRUCTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageStructure").getter(PublishRequest.getter(PublishRequest::messageStructure)).setter(PublishRequest.setter(Builder::messageStructure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageStructure").build()}).build();
    private static final SdkField<Map<String, MessageAttributeValue>> MESSAGE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MessageAttributes").getter(PublishRequest.getter(PublishRequest::messageAttributes)).setter(PublishRequest.setter(Builder::messageAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAttributes").build(), MapTrait.builder().keyLocationName("Name").valueLocationName("Value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_DEDUPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageDeduplicationId").getter(PublishRequest.getter(PublishRequest::messageDeduplicationId)).setter(PublishRequest.setter(Builder::messageDeduplicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageDeduplicationId").build()}).build();
    private static final SdkField<String> MESSAGE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageGroupId").getter(PublishRequest.getter(PublishRequest::messageGroupId)).setter(PublishRequest.setter(Builder::messageGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, TARGET_ARN_FIELD, PHONE_NUMBER_FIELD, MESSAGE_FIELD, SUBJECT_FIELD, MESSAGE_STRUCTURE_FIELD, MESSAGE_ATTRIBUTES_FIELD, MESSAGE_DEDUPLICATION_ID_FIELD, MESSAGE_GROUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PublishRequest.memberNameToFieldInitializer();
    private final String topicArn;
    private final String targetArn;
    private final String phoneNumber;
    private final String message;
    private final String subject;
    private final String messageStructure;
    private final Map<String, MessageAttributeValue> messageAttributes;
    private final String messageDeduplicationId;
    private final String messageGroupId;

    private PublishRequest(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.targetArn = builder.targetArn;
        this.phoneNumber = builder.phoneNumber;
        this.message = builder.message;
        this.subject = builder.subject;
        this.messageStructure = builder.messageStructure;
        this.messageAttributes = builder.messageAttributes;
        this.messageDeduplicationId = builder.messageDeduplicationId;
        this.messageGroupId = builder.messageGroupId;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final String message() {
        return this.message;
    }

    public final String subject() {
        return this.subject;
    }

    public final String messageStructure() {
        return this.messageStructure;
    }

    public final boolean hasMessageAttributes() {
        return this.messageAttributes != null && !(this.messageAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public final String messageDeduplicationId() {
        return this.messageDeduplicationId;
    }

    public final String messageGroupId() {
        return this.messageGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageStructure());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageAttributes() ? this.messageAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.messageDeduplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageGroupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest)((Object)obj);
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.messageStructure(), other.messageStructure()) && this.hasMessageAttributes() == other.hasMessageAttributes() && Objects.equals(this.messageAttributes(), other.messageAttributes()) && Objects.equals(this.messageDeduplicationId(), other.messageDeduplicationId()) && Objects.equals(this.messageGroupId(), other.messageGroupId());
    }

    public final String toString() {
        return ToString.builder((String)"PublishRequest").add("TopicArn", (Object)this.topicArn()).add("TargetArn", (Object)this.targetArn()).add("PhoneNumber", (Object)(this.phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("Message", (Object)this.message()).add("Subject", (Object)this.subject()).add("MessageStructure", (Object)this.messageStructure()).add("MessageAttributes", this.hasMessageAttributes() ? this.messageAttributes() : null).add("MessageDeduplicationId", (Object)this.messageDeduplicationId()).add("MessageGroupId", (Object)this.messageGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "TargetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "MessageStructure": {
                return Optional.ofNullable(clazz.cast(this.messageStructure()));
            }
            case "MessageAttributes": {
                return Optional.ofNullable(clazz.cast(this.messageAttributes()));
            }
            case "MessageDeduplicationId": {
                return Optional.ofNullable(clazz.cast(this.messageDeduplicationId()));
            }
            case "MessageGroupId": {
                return Optional.ofNullable(clazz.cast(this.messageGroupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TopicArn", TOPIC_ARN_FIELD);
        map.put("TargetArn", TARGET_ARN_FIELD);
        map.put("PhoneNumber", PHONE_NUMBER_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("MessageStructure", MESSAGE_STRUCTURE_FIELD);
        map.put("MessageAttributes", MESSAGE_ATTRIBUTES_FIELD);
        map.put("MessageDeduplicationId", MESSAGE_DEDUPLICATION_ID_FIELD);
        map.put("MessageGroupId", MESSAGE_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublishRequest, T> g) {
        return obj -> g.apply((PublishRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsRequest.BuilderImpl
    implements Builder {
        private String topicArn;
        private String targetArn;
        private String phoneNumber;
        private String message;
        private String subject;
        private String messageStructure;
        private Map<String, MessageAttributeValue> messageAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String messageDeduplicationId;
        private String messageGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishRequest model) {
            super(model);
            this.topicArn(model.topicArn);
            this.targetArn(model.targetArn);
            this.phoneNumber(model.phoneNumber);
            this.message(model.message);
            this.subject(model.subject);
            this.messageStructure(model.messageStructure);
            this.messageAttributes(model.messageAttributes);
            this.messageDeduplicationId(model.messageDeduplicationId);
            this.messageGroupId(model.messageGroupId);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getMessageStructure() {
            return this.messageStructure;
        }

        public final void setMessageStructure(String messageStructure) {
            this.messageStructure = messageStructure;
        }

        @Override
        public final Builder messageStructure(String messageStructure) {
            this.messageStructure = messageStructure;
            return this;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            Map<String, MessageAttributeValue.Builder> result = MessageAttributeMapCopier.copyToBuilder(this.messageAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final String getMessageDeduplicationId() {
            return this.messageDeduplicationId;
        }

        public final void setMessageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
        }

        @Override
        public final Builder messageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
            return this;
        }

        public final String getMessageGroupId() {
            return this.messageGroupId;
        }

        public final void setMessageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
        }

        @Override
        public final Builder messageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishRequest build() {
            return new PublishRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SnsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishRequest> {
        public Builder topicArn(String var1);

        public Builder targetArn(String var1);

        public Builder phoneNumber(String var1);

        public Builder message(String var1);

        public Builder subject(String var1);

        public Builder messageStructure(String var1);

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);

        public Builder messageDeduplicationId(String var1);

        public Builder messageGroupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

