/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStateMachineAliasResponse extends SfnResponse implements
        ToCopyableBuilder<DescribeStateMachineAliasResponse.Builder, DescribeStateMachineAliasResponse> {
    private static final SdkField<String> STATE_MACHINE_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineAliasArn").getter(getter(DescribeStateMachineAliasResponse::stateMachineAliasArn))
            .setter(setter(Builder::stateMachineAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineAliasArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DescribeStateMachineAliasResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeStateMachineAliasResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<RoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField
            .<List<RoutingConfigurationListItem>> builder(MarshallingType.LIST)
            .memberName("routingConfiguration")
            .getter(getter(DescribeStateMachineAliasResponse::routingConfiguration))
            .setter(setter(Builder::routingConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutingConfigurationListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutingConfigurationListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(DescribeStateMachineAliasResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDate").getter(getter(DescribeStateMachineAliasResponse::updateDate))
            .setter(setter(Builder::updateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ALIAS_ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIGURATION_FIELD, CREATION_DATE_FIELD, UPDATE_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stateMachineAliasArn;

    private final String name;

    private final String description;

    private final List<RoutingConfigurationListItem> routingConfiguration;

    private final Instant creationDate;

    private final Instant updateDate;

    private DescribeStateMachineAliasResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineAliasArn = builder.stateMachineAliasArn;
        this.name = builder.name;
        this.description = builder.description;
        this.routingConfiguration = builder.routingConfiguration;
        this.creationDate = builder.creationDate;
        this.updateDate = builder.updateDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine alias.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the state machine alias.
     */
    public final String stateMachineAliasArn() {
        return stateMachineAliasArn;
    }

    /**
     * <p>
     * The name of the state machine alias.
     * </p>
     * 
     * @return The name of the state machine alias.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the alias.
     * </p>
     * 
     * @return A description of the alias.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutingConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutingConfiguration() {
        return routingConfiguration != null && !(routingConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routing configuration of the alias.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutingConfiguration} method.
     * </p>
     * 
     * @return The routing configuration of the alias.
     */
    public final List<RoutingConfigurationListItem> routingConfiguration() {
        return routingConfiguration;
    }

    /**
     * <p>
     * The date the state machine alias was created.
     * </p>
     * 
     * @return The date the state machine alias was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date the state machine alias was last updated.
     * </p>
     * <p>
     * For a newly created state machine, this is the same as the creation date.
     * </p>
     * 
     * @return The date the state machine alias was last updated.</p>
     *         <p>
     *         For a newly created state machine, this is the same as the creation date.
     */
    public final Instant updateDate() {
        return updateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutingConfiguration() ? routingConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(updateDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStateMachineAliasResponse)) {
            return false;
        }
        DescribeStateMachineAliasResponse other = (DescribeStateMachineAliasResponse) obj;
        return Objects.equals(stateMachineAliasArn(), other.stateMachineAliasArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && hasRoutingConfiguration() == other.hasRoutingConfiguration()
                && Objects.equals(routingConfiguration(), other.routingConfiguration())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(updateDate(), other.updateDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStateMachineAliasResponse").add("StateMachineAliasArn", stateMachineAliasArn())
                .add("Name", name()).add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RoutingConfiguration", hasRoutingConfiguration() ? routingConfiguration() : null)
                .add("CreationDate", creationDate()).add("UpdateDate", updateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineAliasArn":
            return Optional.ofNullable(clazz.cast(stateMachineAliasArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "routingConfiguration":
            return Optional.ofNullable(clazz.cast(routingConfiguration()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "updateDate":
            return Optional.ofNullable(clazz.cast(updateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stateMachineAliasArn", STATE_MACHINE_ALIAS_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("routingConfiguration", ROUTING_CONFIGURATION_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("updateDate", UPDATE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStateMachineAliasResponse, T> g) {
        return obj -> g.apply((DescribeStateMachineAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStateMachineAliasResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the state machine alias.
         * </p>
         * 
         * @param stateMachineAliasArn
         *        The Amazon Resource Name (ARN) of the state machine alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineAliasArn(String stateMachineAliasArn);

        /**
         * <p>
         * The name of the state machine alias.
         * </p>
         * 
         * @param name
         *        The name of the state machine alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the alias.
         * </p>
         * 
         * @param description
         *        A description of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The routing configuration of the alias.
         * </p>
         * 
         * @param routingConfiguration
         *        The routing configuration of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfiguration(Collection<RoutingConfigurationListItem> routingConfiguration);

        /**
         * <p>
         * The routing configuration of the alias.
         * </p>
         * 
         * @param routingConfiguration
         *        The routing configuration of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfiguration(RoutingConfigurationListItem... routingConfiguration);

        /**
         * <p>
         * The routing configuration of the alias.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sfn.model.RoutingConfigurationListItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sfn.model.RoutingConfigurationListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sfn.model.RoutingConfigurationListItem.Builder#build()} is called
         * immediately and its result is passed to {@link #routingConfiguration(List<RoutingConfigurationListItem>)}.
         * 
         * @param routingConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sfn.model.RoutingConfigurationListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingConfiguration(java.util.Collection<RoutingConfigurationListItem>)
         */
        Builder routingConfiguration(Consumer<RoutingConfigurationListItem.Builder>... routingConfiguration);

        /**
         * <p>
         * The date the state machine alias was created.
         * </p>
         * 
         * @param creationDate
         *        The date the state machine alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date the state machine alias was last updated.
         * </p>
         * <p>
         * For a newly created state machine, this is the same as the creation date.
         * </p>
         * 
         * @param updateDate
         *        The date the state machine alias was last updated.</p>
         *        <p>
         *        For a newly created state machine, this is the same as the creation date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(Instant updateDate);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String stateMachineAliasArn;

        private String name;

        private String description;

        private List<RoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDate;

        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStateMachineAliasResponse model) {
            super(model);
            stateMachineAliasArn(model.stateMachineAliasArn);
            name(model.name);
            description(model.description);
            routingConfiguration(model.routingConfiguration);
            creationDate(model.creationDate);
            updateDate(model.updateDate);
        }

        public final String getStateMachineAliasArn() {
            return stateMachineAliasArn;
        }

        public final void setStateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
        }

        @Override
        public final Builder stateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<RoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<RoutingConfigurationListItem.Builder> result = RoutingConfigurationListCopier
                    .copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(Collection<RoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = RoutingConfigurationListCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<RoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = RoutingConfigurationListCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(RoutingConfigurationListItem... routingConfiguration) {
            routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<RoutingConfigurationListItem.Builder>... routingConfiguration) {
            routingConfiguration(Stream.of(routingConfiguration)
                    .map(c -> RoutingConfigurationListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getUpdateDate() {
            return updateDate;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        @Override
        public DescribeStateMachineAliasResponse build() {
            return new DescribeStateMachineAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
