/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeStatistics> {
    private static final SdkField<Long> INBOX_RAW_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("InboxRawCount").getter(VolumeStatistics.getter(VolumeStatistics::inboxRawCount)).setter(VolumeStatistics.setter(Builder::inboxRawCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboxRawCount").build()}).build();
    private static final SdkField<Long> SPAM_RAW_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SpamRawCount").getter(VolumeStatistics.getter(VolumeStatistics::spamRawCount)).setter(VolumeStatistics.setter(Builder::spamRawCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpamRawCount").build()}).build();
    private static final SdkField<Long> PROJECTED_INBOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProjectedInbox").getter(VolumeStatistics.getter(VolumeStatistics::projectedInbox)).setter(VolumeStatistics.setter(Builder::projectedInbox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectedInbox").build()}).build();
    private static final SdkField<Long> PROJECTED_SPAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProjectedSpam").getter(VolumeStatistics.getter(VolumeStatistics::projectedSpam)).setter(VolumeStatistics.setter(Builder::projectedSpam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectedSpam").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INBOX_RAW_COUNT_FIELD, SPAM_RAW_COUNT_FIELD, PROJECTED_INBOX_FIELD, PROJECTED_SPAM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InboxRawCount", INBOX_RAW_COUNT_FIELD);
            this.put("SpamRawCount", SPAM_RAW_COUNT_FIELD);
            this.put("ProjectedInbox", PROJECTED_INBOX_FIELD);
            this.put("ProjectedSpam", PROJECTED_SPAM_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long inboxRawCount;
    private final Long spamRawCount;
    private final Long projectedInbox;
    private final Long projectedSpam;

    private VolumeStatistics(BuilderImpl builder) {
        this.inboxRawCount = builder.inboxRawCount;
        this.spamRawCount = builder.spamRawCount;
        this.projectedInbox = builder.projectedInbox;
        this.projectedSpam = builder.projectedSpam;
    }

    public final Long inboxRawCount() {
        return this.inboxRawCount;
    }

    public final Long spamRawCount() {
        return this.spamRawCount;
    }

    public final Long projectedInbox() {
        return this.projectedInbox;
    }

    public final Long projectedSpam() {
        return this.projectedSpam;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inboxRawCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.spamRawCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectedInbox());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectedSpam());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatistics)) {
            return false;
        }
        VolumeStatistics other = (VolumeStatistics)obj;
        return Objects.equals(this.inboxRawCount(), other.inboxRawCount()) && Objects.equals(this.spamRawCount(), other.spamRawCount()) && Objects.equals(this.projectedInbox(), other.projectedInbox()) && Objects.equals(this.projectedSpam(), other.projectedSpam());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeStatistics").add("InboxRawCount", (Object)this.inboxRawCount()).add("SpamRawCount", (Object)this.spamRawCount()).add("ProjectedInbox", (Object)this.projectedInbox()).add("ProjectedSpam", (Object)this.projectedSpam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InboxRawCount": {
                return Optional.ofNullable(clazz.cast(this.inboxRawCount()));
            }
            case "SpamRawCount": {
                return Optional.ofNullable(clazz.cast(this.spamRawCount()));
            }
            case "ProjectedInbox": {
                return Optional.ofNullable(clazz.cast(this.projectedInbox()));
            }
            case "ProjectedSpam": {
                return Optional.ofNullable(clazz.cast(this.projectedSpam()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VolumeStatistics, T> g) {
        return obj -> g.apply((VolumeStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long inboxRawCount;
        private Long spamRawCount;
        private Long projectedInbox;
        private Long projectedSpam;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatistics model) {
            this.inboxRawCount(model.inboxRawCount);
            this.spamRawCount(model.spamRawCount);
            this.projectedInbox(model.projectedInbox);
            this.projectedSpam(model.projectedSpam);
        }

        public final Long getInboxRawCount() {
            return this.inboxRawCount;
        }

        public final void setInboxRawCount(Long inboxRawCount) {
            this.inboxRawCount = inboxRawCount;
        }

        @Override
        public final Builder inboxRawCount(Long inboxRawCount) {
            this.inboxRawCount = inboxRawCount;
            return this;
        }

        public final Long getSpamRawCount() {
            return this.spamRawCount;
        }

        public final void setSpamRawCount(Long spamRawCount) {
            this.spamRawCount = spamRawCount;
        }

        @Override
        public final Builder spamRawCount(Long spamRawCount) {
            this.spamRawCount = spamRawCount;
            return this;
        }

        public final Long getProjectedInbox() {
            return this.projectedInbox;
        }

        public final void setProjectedInbox(Long projectedInbox) {
            this.projectedInbox = projectedInbox;
        }

        @Override
        public final Builder projectedInbox(Long projectedInbox) {
            this.projectedInbox = projectedInbox;
            return this;
        }

        public final Long getProjectedSpam() {
            return this.projectedSpam;
        }

        public final void setProjectedSpam(Long projectedSpam) {
            this.projectedSpam = projectedSpam;
        }

        @Override
        public final Builder projectedSpam(Long projectedSpam) {
            this.projectedSpam = projectedSpam;
            return this;
        }

        public VolumeStatistics build() {
            return new VolumeStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeStatistics> {
        public Builder inboxRawCount(Long var1);

        public Builder spamRawCount(Long var1);

        public Builder projectedInbox(Long var1);

        public Builder projectedSpam(Long var1);
    }
}

