/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The VDM attributes that apply to your Amazon SES account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VdmAttributes implements SdkPojo, Serializable, ToCopyableBuilder<VdmAttributes.Builder, VdmAttributes> {
    private static final SdkField<String> VDM_ENABLED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VdmEnabled").getter(getter(VdmAttributes::vdmEnabledAsString)).setter(setter(Builder::vdmEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VdmEnabled").build()).build();

    private static final SdkField<DashboardAttributes> DASHBOARD_ATTRIBUTES_FIELD = SdkField
            .<DashboardAttributes> builder(MarshallingType.SDK_POJO).memberName("DashboardAttributes")
            .getter(getter(VdmAttributes::dashboardAttributes)).setter(setter(Builder::dashboardAttributes))
            .constructor(DashboardAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardAttributes").build())
            .build();

    private static final SdkField<GuardianAttributes> GUARDIAN_ATTRIBUTES_FIELD = SdkField
            .<GuardianAttributes> builder(MarshallingType.SDK_POJO).memberName("GuardianAttributes")
            .getter(getter(VdmAttributes::guardianAttributes)).setter(setter(Builder::guardianAttributes))
            .constructor(GuardianAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuardianAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VDM_ENABLED_FIELD,
            DASHBOARD_ATTRIBUTES_FIELD, GUARDIAN_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("VdmEnabled", VDM_ENABLED_FIELD);
                    put("DashboardAttributes", DASHBOARD_ATTRIBUTES_FIELD);
                    put("GuardianAttributes", GUARDIAN_ATTRIBUTES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String vdmEnabled;

    private final DashboardAttributes dashboardAttributes;

    private final GuardianAttributes guardianAttributes;

    private VdmAttributes(BuilderImpl builder) {
        this.vdmEnabled = builder.vdmEnabled;
        this.dashboardAttributes = builder.dashboardAttributes;
        this.guardianAttributes = builder.guardianAttributes;
    }

    /**
     * <p>
     * Specifies the status of your VDM configuration. Can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – Amazon SES enables VDM for your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – Amazon SES disables VDM for your account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vdmEnabled} will
     * return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vdmEnabledAsString}.
     * </p>
     * 
     * @return Specifies the status of your VDM configuration. Can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – Amazon SES enables VDM for your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – Amazon SES disables VDM for your account.
     *         </p>
     *         </li>
     * @see FeatureStatus
     */
    public final FeatureStatus vdmEnabled() {
        return FeatureStatus.fromValue(vdmEnabled);
    }

    /**
     * <p>
     * Specifies the status of your VDM configuration. Can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – Amazon SES enables VDM for your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – Amazon SES disables VDM for your account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vdmEnabled} will
     * return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vdmEnabledAsString}.
     * </p>
     * 
     * @return Specifies the status of your VDM configuration. Can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – Amazon SES enables VDM for your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – Amazon SES disables VDM for your account.
     *         </p>
     *         </li>
     * @see FeatureStatus
     */
    public final String vdmEnabledAsString() {
        return vdmEnabled;
    }

    /**
     * <p>
     * Specifies additional settings for your VDM configuration as applicable to the Dashboard.
     * </p>
     * 
     * @return Specifies additional settings for your VDM configuration as applicable to the Dashboard.
     */
    public final DashboardAttributes dashboardAttributes() {
        return dashboardAttributes;
    }

    /**
     * <p>
     * Specifies additional settings for your VDM configuration as applicable to the Guardian.
     * </p>
     * 
     * @return Specifies additional settings for your VDM configuration as applicable to the Guardian.
     */
    public final GuardianAttributes guardianAttributes() {
        return guardianAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vdmEnabledAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(guardianAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VdmAttributes)) {
            return false;
        }
        VdmAttributes other = (VdmAttributes) obj;
        return Objects.equals(vdmEnabledAsString(), other.vdmEnabledAsString())
                && Objects.equals(dashboardAttributes(), other.dashboardAttributes())
                && Objects.equals(guardianAttributes(), other.guardianAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VdmAttributes").add("VdmEnabled", vdmEnabledAsString())
                .add("DashboardAttributes", dashboardAttributes()).add("GuardianAttributes", guardianAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VdmEnabled":
            return Optional.ofNullable(clazz.cast(vdmEnabledAsString()));
        case "DashboardAttributes":
            return Optional.ofNullable(clazz.cast(dashboardAttributes()));
        case "GuardianAttributes":
            return Optional.ofNullable(clazz.cast(guardianAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VdmAttributes, T> g) {
        return obj -> g.apply((VdmAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VdmAttributes> {
        /**
         * <p>
         * Specifies the status of your VDM configuration. Can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – Amazon SES enables VDM for your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – Amazon SES disables VDM for your account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param vdmEnabled
         *        Specifies the status of your VDM configuration. Can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – Amazon SES enables VDM for your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – Amazon SES disables VDM for your account.
         *        </p>
         *        </li>
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder vdmEnabled(String vdmEnabled);

        /**
         * <p>
         * Specifies the status of your VDM configuration. Can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – Amazon SES enables VDM for your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – Amazon SES disables VDM for your account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param vdmEnabled
         *        Specifies the status of your VDM configuration. Can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – Amazon SES enables VDM for your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – Amazon SES disables VDM for your account.
         *        </p>
         *        </li>
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder vdmEnabled(FeatureStatus vdmEnabled);

        /**
         * <p>
         * Specifies additional settings for your VDM configuration as applicable to the Dashboard.
         * </p>
         * 
         * @param dashboardAttributes
         *        Specifies additional settings for your VDM configuration as applicable to the Dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardAttributes(DashboardAttributes dashboardAttributes);

        /**
         * <p>
         * Specifies additional settings for your VDM configuration as applicable to the Dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashboardAttributes.Builder} avoiding the
         * need to create one manually via {@link DashboardAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashboardAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #dashboardAttributes(DashboardAttributes)}.
         * 
         * @param dashboardAttributes
         *        a consumer that will call methods on {@link DashboardAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardAttributes(DashboardAttributes)
         */
        default Builder dashboardAttributes(Consumer<DashboardAttributes.Builder> dashboardAttributes) {
            return dashboardAttributes(DashboardAttributes.builder().applyMutation(dashboardAttributes).build());
        }

        /**
         * <p>
         * Specifies additional settings for your VDM configuration as applicable to the Guardian.
         * </p>
         * 
         * @param guardianAttributes
         *        Specifies additional settings for your VDM configuration as applicable to the Guardian.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardianAttributes(GuardianAttributes guardianAttributes);

        /**
         * <p>
         * Specifies additional settings for your VDM configuration as applicable to the Guardian.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardianAttributes.Builder} avoiding the
         * need to create one manually via {@link GuardianAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardianAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #guardianAttributes(GuardianAttributes)}.
         * 
         * @param guardianAttributes
         *        a consumer that will call methods on {@link GuardianAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardianAttributes(GuardianAttributes)
         */
        default Builder guardianAttributes(Consumer<GuardianAttributes.Builder> guardianAttributes) {
            return guardianAttributes(GuardianAttributes.builder().applyMutation(guardianAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String vdmEnabled;

        private DashboardAttributes dashboardAttributes;

        private GuardianAttributes guardianAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(VdmAttributes model) {
            vdmEnabled(model.vdmEnabled);
            dashboardAttributes(model.dashboardAttributes);
            guardianAttributes(model.guardianAttributes);
        }

        public final String getVdmEnabled() {
            return vdmEnabled;
        }

        public final void setVdmEnabled(String vdmEnabled) {
            this.vdmEnabled = vdmEnabled;
        }

        @Override
        public final Builder vdmEnabled(String vdmEnabled) {
            this.vdmEnabled = vdmEnabled;
            return this;
        }

        @Override
        public final Builder vdmEnabled(FeatureStatus vdmEnabled) {
            this.vdmEnabled(vdmEnabled == null ? null : vdmEnabled.toString());
            return this;
        }

        public final DashboardAttributes.Builder getDashboardAttributes() {
            return dashboardAttributes != null ? dashboardAttributes.toBuilder() : null;
        }

        public final void setDashboardAttributes(DashboardAttributes.BuilderImpl dashboardAttributes) {
            this.dashboardAttributes = dashboardAttributes != null ? dashboardAttributes.build() : null;
        }

        @Override
        public final Builder dashboardAttributes(DashboardAttributes dashboardAttributes) {
            this.dashboardAttributes = dashboardAttributes;
            return this;
        }

        public final GuardianAttributes.Builder getGuardianAttributes() {
            return guardianAttributes != null ? guardianAttributes.toBuilder() : null;
        }

        public final void setGuardianAttributes(GuardianAttributes.BuilderImpl guardianAttributes) {
            this.guardianAttributes = guardianAttributes != null ? guardianAttributes.build() : null;
        }

        @Override
        public final Builder guardianAttributes(GuardianAttributes guardianAttributes) {
            this.guardianAttributes = guardianAttributes;
            return this;
        }

        @Override
        public VdmAttributes build() {
            return new VdmAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
