/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactsRequest extends SesV2Request implements
        ToCopyableBuilder<ListContactsRequest.Builder, ListContactsRequest> {
    private static final SdkField<String> CONTACT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactListName").getter(getter(ListContactsRequest::contactListName))
            .setter(setter(Builder::contactListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactListName").build()).build();

    private static final SdkField<ListContactsFilter> FILTER_FIELD = SdkField
            .<ListContactsFilter> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(ListContactsRequest::filter)).setter(setter(Builder::filter)).constructor(ListContactsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListContactsRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContactsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LIST_NAME_FIELD,
            FILTER_FIELD, PAGE_SIZE_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ContactListName", CONTACT_LIST_NAME_FIELD);
                    put("Filter", FILTER_FIELD);
                    put("PageSize", PAGE_SIZE_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final String contactListName;

    private final ListContactsFilter filter;

    private final Integer pageSize;

    private final String nextToken;

    private ListContactsRequest(BuilderImpl builder) {
        super(builder);
        this.contactListName = builder.contactListName;
        this.filter = builder.filter;
        this.pageSize = builder.pageSize;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the contact list.
     * </p>
     * 
     * @return The name of the contact list.
     */
    public final String contactListName() {
        return contactListName;
    }

    /**
     * <p>
     * A filter that can be applied to a list of contacts.
     * </p>
     * 
     * @return A filter that can be applied to a list of contacts.
     */
    public final ListContactsFilter filter() {
        return filter;
    }

    /**
     * <p>
     * The number of contacts that may be returned at once, which is dependent on if there are more or less contacts
     * than the value of the PageSize. Use this parameter to paginate results. If additional contacts exist beyond the
     * specified limit, the <code>NextToken</code> element is sent in the response. Use the <code>NextToken</code> value
     * in subsequent requests to retrieve additional contacts.
     * </p>
     * 
     * @return The number of contacts that may be returned at once, which is dependent on if there are more or less
     *         contacts than the value of the PageSize. Use this parameter to paginate results. If additional contacts
     *         exist beyond the specified limit, the <code>NextToken</code> element is sent in the response. Use the
     *         <code>NextToken</code> value in subsequent requests to retrieve additional contacts.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * A string token indicating that there might be additional contacts available to be listed. Use the token provided
     * in the Response to use in the subsequent call to ListContacts with the same parameters to retrieve the next page
     * of contacts.
     * </p>
     * 
     * @return A string token indicating that there might be additional contacts available to be listed. Use the token
     *         provided in the Response to use in the subsequent call to ListContacts with the same parameters to
     *         retrieve the next page of contacts.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactListName());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactsRequest)) {
            return false;
        }
        ListContactsRequest other = (ListContactsRequest) obj;
        return Objects.equals(contactListName(), other.contactListName()) && Objects.equals(filter(), other.filter())
                && Objects.equals(pageSize(), other.pageSize()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContactsRequest").add("ContactListName", contactListName()).add("Filter", filter())
                .add("PageSize", pageSize()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactListName":
            return Optional.ofNullable(clazz.cast(contactListName()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListContactsRequest, T> g) {
        return obj -> g.apply((ListContactsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListContactsRequest> {
        /**
         * <p>
         * The name of the contact list.
         * </p>
         * 
         * @param contactListName
         *        The name of the contact list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactListName(String contactListName);

        /**
         * <p>
         * A filter that can be applied to a list of contacts.
         * </p>
         * 
         * @param filter
         *        A filter that can be applied to a list of contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(ListContactsFilter filter);

        /**
         * <p>
         * A filter that can be applied to a list of contacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListContactsFilter.Builder} avoiding the
         * need to create one manually via {@link ListContactsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListContactsFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(ListContactsFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link ListContactsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(ListContactsFilter)
         */
        default Builder filter(Consumer<ListContactsFilter.Builder> filter) {
            return filter(ListContactsFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The number of contacts that may be returned at once, which is dependent on if there are more or less contacts
         * than the value of the PageSize. Use this parameter to paginate results. If additional contacts exist beyond
         * the specified limit, the <code>NextToken</code> element is sent in the response. Use the
         * <code>NextToken</code> value in subsequent requests to retrieve additional contacts.
         * </p>
         * 
         * @param pageSize
         *        The number of contacts that may be returned at once, which is dependent on if there are more or less
         *        contacts than the value of the PageSize. Use this parameter to paginate results. If additional
         *        contacts exist beyond the specified limit, the <code>NextToken</code> element is sent in the response.
         *        Use the <code>NextToken</code> value in subsequent requests to retrieve additional contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * A string token indicating that there might be additional contacts available to be listed. Use the token
         * provided in the Response to use in the subsequent call to ListContacts with the same parameters to retrieve
         * the next page of contacts.
         * </p>
         * 
         * @param nextToken
         *        A string token indicating that there might be additional contacts available to be listed. Use the
         *        token provided in the Response to use in the subsequent call to ListContacts with the same parameters
         *        to retrieve the next page of contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String contactListName;

        private ListContactsFilter filter;

        private Integer pageSize;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactsRequest model) {
            super(model);
            contactListName(model.contactListName);
            filter(model.filter);
            pageSize(model.pageSize);
            nextToken(model.nextToken);
        }

        public final String getContactListName() {
            return contactListName;
        }

        public final void setContactListName(String contactListName) {
            this.contactListName = contactListName;
        }

        @Override
        public final Builder contactListName(String contactListName) {
            this.contactListName = contactListName;
            return this;
        }

        public final ListContactsFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(ListContactsFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ListContactsFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListContactsRequest build() {
            return new ListContactsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
